/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef CHANLIST_H
#define CHANLIST_H

#include <qlistbox.h>
#include <qpainter.h>
#include "kv4lapp.h"

struct ChanToFreqItem
{
	float freqStart, freqEnd, freqStep;
	int chanStart, chanEnd;
	ChanToFreqItem * next;
};



class ChanListItem : public QListBoxItem
{
public:
	ChanListItem( const char * name="", int chan=1, 
		int fine=0, int input=0, int format=0);

	const char * name() const { return text();}
	int chan() const { return ch;}
	int fine() const { return fi;}
	int input() const { return in;}
	int format() const { return fo;}

	void setName( const char * name) { setText(name);}
 	void setChan( int chan) { ch=chan;}
 	void setFine( int fine) { fi=fine;}
 	void setInput( int input) { in=input;}
 	void setFormat( int format) { fo=format;}
		
private:
	int ch, fi, in, fo;

protected:
	virtual void paint( QPainter * );
	virtual int height( const QListBox * ) const;
	virtual int width( const QListBox * ) const;
};



class ChanList : public QListBox
{
	Q_OBJECT

public:
	ChanList(KConfig *);
	void paint(){ updateItem(currentItem(), true);}
	ChanListItem * getItem(int);
	void chanToFreqClear();
	void chanToFreqAdd(QStrList *);
	void whatHighlighted();
	bool getDND(){ return dnd;}
	void setDND(bool f=false){dnd = f;}
	void hide();			
	
public slots:
	void previous();
	void next();
	void setName(const char *);
 	void setChan(int);
 	void setFine(int);
 	void setInput(int);
 	void setFormat(int);
	void cloneCurrentItem();
	void removeCurrentItem();
	
private slots:
	void emitAll(int);
	

signals:
	void nameChanged(const char *);
	void chanChanged(int);
	void fineChanged(int);
	void inputChanged(int);
	void formatChanged(int);
	void freqChanged(unsigned long);

	
protected:
	ChanListItem * item (int) const;
	struct ChanToFreqItem * chanToFreqItem;
	void mouseReleaseEvent(QMouseEvent *);
private:
	unsigned long chanToFreq( int, int);
	KConfig * cfg;
	int saveItemNum;
	ChanToFreqItem * firstChanToFreqItem;
	void changeCurrentPos(int i);
	bool dnd;	
};

#endif // CHANLIST_H
