#ifndef WAVE_H_INCLUDED
#define WAVE_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <defines.h>

class wave_t
{
private:
	sample_t *data;
	size_t size; // in frames (!!)
	size_t numchans;
	size_t rate;
	size_t bps;  // bits per sample

	char *sample_filename;

public:
	wave_t();
	~wave_t();

	bool load_sample( const char *filename );
	void printInfo();

	inline const char *get_filename() const { return sample_filename; }
	inline const sample_t *get_buffer() const { return data; }
	inline size_t get_size() const { return size; }

private:
	bool try_wav_format( FILE *f );
	void try_raw_format( FILE *f );
	void resample( DWORD to_rate );
	void monoify();
};

#endif
