#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <errno.h>
#include <util.h>

void debug_printf( const char *fmt, ... )
{
	va_list args;
	va_start( args, fmt );
	vfprintf( stderr, fmt, args );
	va_end( args );
}

bool checkFilename( const char *filename )
{
	int fd;

	fd = open( filename, O_WRONLY | O_NONBLOCK );

	if ( fd == -1 ) {
		if ( errno == EBUSY  ) {
			return true;
		} else {
			return false;
		}
	}

	// else
	close( fd );
	return true;
}

