#ifndef SONGBAR_H_INCLUDED
#define SONGBAR_H_INCLUDED

#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include "bcheckletter.h"
#include "bpopselect.h"
#include "bpatternbar.h"
#include "btrackedit.h"
#include "ttracker.h"

class SongBar : public QFrame {
Q_OBJECT
private:
    BTrackEditButton *type;
    BPopSelect *mchan;
    QLineEdit *name;
    BPopSelect *devnum;
    BCheckLetter *mute;
    BCheckLetter *solo;
    QFrame *sep;
    BPatternBar *patterns;
    TTracker *tracker;
    int channel;
    int leftbarwidth;
private slots:
    void _barCursorUp( int pos );
    void _barCursorDown( int pos );
    void _barGiveCursor( int pos );
    void _patternClicked( int pos );
    void _mchannelChanged( int mchan );
    void _deviceChanged( int newdev );
    void _muteChanged( bool newmute );
    void _soloChanged( bool newsolo );
public:
    SongBar( int chan, QWidget *parent );
    void getBarCursor( int pos );
    void noBarCursor();
    void reSync();
    void setName( const char *newname );
    const char *getName();
    int leftBarWidth();
public slots:
    void scrollPatternBar( int newpos );
    void zoomInPattern();
    void zoomOutPattern();
signals:
    void barCursorUp( int, int  );
    void barCursorDown( int, int );
    void barGiveCursor( int, int );
};

#endif
