#include <stdlib.h>
#include <qpainter.h>
#include <btoolbutton.h>
#include <btoolbutton.moc>

BToolButton::BToolButton( bool pressable, QPixmap *_icon, QWidget *parent )
	: QFrame( parent, 0, 0, TRUE )
{
	setLineWidth( 2 );

	ispressed = false;
	ispressable = pressable;

	nopixmap = false;
	icon = _icon;
}

BToolButton::BToolButton( bool pressable, QWidget *parent )
	: QFrame( parent, 0, 0, TRUE )
{
	setLineWidth( 2 );

	nopixmap = true;
	ispressed = false;
	ispressable = pressable;
	thetext = NULL;
}

void BToolButton::setText( const char *text )
{
	if ( thetext != NULL ) {
		free( thetext );
	}

	thetext = ( char * ) malloc( strlen( text ) * sizeof( char ) );
	strcpy( thetext, text );
	repaint();
}

void BToolButton::setPressed( bool press )
{
	ispressed = press;

	if ( ispressed == true ) {
		setFrameStyle( QFrame::Panel | QFrame::Sunken );
		repaint();
	} else {
		enterEvent( NULL );
		leaveEvent( NULL );
	}

	stateChanged( ispressed );
}

void BToolButton::enterEvent( QEvent *e )
{
	if ( ispressed != true ) {
		setFrameStyle( QFrame::Panel | QFrame::Raised );
		repaint();
	}
}

void BToolButton::leaveEvent( QEvent *e )
{
	if ( ispressed != true ) {
		setFrameStyle( QFrame::NoFrame );
		repaint();
	}
}

void BToolButton::mousePressEvent( QMouseEvent *mev )
{
	if ( ispressable == true ) {
		setPressed( !ispressed );
	} else {
		setFrameStyle( QFrame::Panel | QFrame::Sunken );
		repaint();
		pressed();
	}
}

void BToolButton::mouseReleaseEvent( QMouseEvent *mev )
{
	if ( ispressable == false ) {
		enterEvent( NULL );
	}
}

void BToolButton::paintEvent( QPaintEvent *pev )
{
	QPainter paint( this );

	if ( nopixmap != true ) {
		paint.drawPixmap( 1, 1, *icon );
	} else {
		paint.drawText( 5, 17, thetext );
	}
	paint.end();

	QFrame::paintEvent( pev );
}

