// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MText.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#define MODULE_NAME "text"

#include "ModuleMacros.h"

#include <stdlib.h> // atof()
#include <stdio.h>

BEGIN_MODULE_DEFINITION(Text);
     Text value;
public:
     Text getValue() const { return value; };
     void   setValue(Text v) { value=v; };
     string toString() const;
END_MODULE_DEFINITION(Text);


class PNSTextOutput : public PreparedTextSignal
{
    Text *value;
public:
    PNSTextOutput(Text *value) : value(value) {};
    Text getText() { return *value; };
};


class NSTextOutput : public Signal
{
    Text *value;
public:
    NSTextOutput(Module *m, Text *v) 
	: Signal(TEXT_TYPE, "output", "Text entered by user", m), value(v) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *) 
	{ return new PNSTextOutput(value); };
};


MText::MText(string string)
{
    value = string;
    addConnector(new NSTextOutput(this, &value));
}

string MText::toString() const
{
    return value;
}
