
#include "MScalarDisplay.h"

#include <stdio.h> // DEBUGGING

class MGScalarDisplay : public ModuleGenerator
{
    string name;
public:
    MGScalarDisplay(string name) : name(name) {};
    Module *create(string) const { return new MScalarDisplay(name); };
    string getName() const { return name; };
};

MGScalarDisplay mg_scalar_display[] = { 
    string("analog-scalar-display-a"), 
    string("analog-scalar-display-b"), 
    string("green-led"), 
    string("red-led"), 
    string("blue-led"), 
    string("yellow-led"), 
    string("violet-led"), 
    string("digital-scalar-display") 
};

class SSScalarDisplayOutput : public Signal
{
public:
    SSScalarDisplayOutput(MScalarDisplay *m) : 
	Signal(SOUND_TYPE, "output", "Input piped through", m) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *);
};

class PSSScalarDisplayOutput : public PreparedSoundSignal
{
    PreparedSoundSignal  *pssig_input;
    PreparedNumberSignal *pnsig_value;
    PreparedNumberSignal *pnsig_inertia;
    MScalarDisplay       *module;
public:
    PSSScalarDisplayOutput(PreparedSoundSignal *pssig_input, 
			   PreparedNumberSignal *pnsig_value, 
			   PreparedNumberSignal *pnsig_inertia,
			   MScalarDisplay *module)
	: pssig_input(pssig_input), pnsig_value(pnsig_value) 
	, pnsig_inertia(pnsig_inertia), module(module) {};
    ~PSSScalarDisplayOutput() { delete pssig_input; delete pnsig_value; delete pnsig_inertia; };
    SoundPortion getSoundPortion(long start_time, long number_of_samples);
};

// ----------------------------------------------------------------------

MScalarDisplay::MScalarDisplay(string name)
    : name(name)
    , value(0)
{
    addConnector(sslot_input = new Slot(SOUND_TYPE, "input", "Input", this, 6));
    addConnector(nslot_value = new Slot(NUMBER_TYPE, "value", "Value to display", this, 12));
    addConnector(nslot_inertia = new Slot(NUMBER_TYPE, "inertia", "Sluggishness, 0=none", this, 11));
    addConnector(new SSScalarDisplayOutput(this));
}


void MScalarDisplay::setValue(Number v)
{
    value = v;
}


PreparedSignal *SSScalarDisplayOutput::prepareSignal(Metainfo *mi, 
						     const Parameterset *parset)
{
    // Parameters and metainfo are just passed trough in both directions
    MScalarDisplay *m = (MScalarDisplay *)getModule();
    PSSScalarDisplayOutput *pss = new PSSScalarDisplayOutput(
	getPreparedSoundSignal(this, m->sslot_input, mi, parset),
	getPreparedNumberSignal(this, m->nslot_value, 0.0),
	getPreparedNumberSignal(this, m->nslot_inertia, 0.5),
	m);
    return pss;
}


SoundPortion PSSScalarDisplayOutput::getSoundPortion(long start_time, long number_of_samples)
{
    // Just give trough answer from input. But this is the time to get also the
    // value to display and store it for graphical update!
    SoundPortion result=pssig_input->getSoundPortion(start_time, number_of_samples);

    // Now set the current value of the display. Note, that the
    // display does only make sense, if only ONE data stream is going
    // through it. If it is watching more, only the last one to be
    // executed is displayed. Which one this is is not defined.

    // The inertia is defined like this:
    // 0 = no inertia, old value is irrelevant
    // 1 = 100% inertia, old value stays!
    // <0 = 0, >1 = 1
    // ]0,1[ : weight of old value = 1/(1-inertia)

    Number inertia = pnsig_inertia->getNumber();
    if (inertia <= 0) module->setValue(pnsig_value->getNumber());
    else if (inertia < 1) {
	Number oldvalue = module->getValue();
	Number weight = 1.0 / (1.0 - inertia);
	module->setValue((pnsig_value->getNumber() + oldvalue * weight) / (weight + 1));
    }
    return result;
}
