// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MNumber.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#include <stdlib.h> // atof()
#include <stdio.h>

#include "ModuleMacros.h"
#include "MNumber.h"
#include "PNSigStoredNumber.h"

class NSigNumberOutput : public Signal
{
    Number *value;
public:
    NSigNumberOutput(Module *m, Number *v) 
	: Signal(NUMBER_TYPE, "output", "Number entered by user", m), value(v) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *) 
	{ return new PNSigStoredNumber(value); };
};


MODULE_GENERATOR("number", Number);

string MNumber::toString()   const { return ::toString(value); }
string MNumber::getName()    const { return "number"; }
Number MNumber::getValue()   const { return value; }
void   MNumber::setValue(Number v) { value = v; }

MNumber::MNumber(string str)
{
    value = atof(str.c_str());
    addConnector(new NSigNumberOutput(this, &value));
}

