// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MConnector.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#include "ModuleMacros.h"

/**
 * @short Provide external Signals and Slots for a MacroModule.
 */
class MConnector : public Module
{
    /**
     * The Signal or Slot by that the MacroModule can be wired
     * from outside.
     */
    Connector *external_connector;

    /**
     * The Slot or Signal that makes the connection to one of the
     * inner Signals or Slots.
     */
    Connector *internal_connector;

public:
    MConnector(SignalType signal_type, bool external_signal, string constructor_string);

    ~MConnector();

    void setConnectorName(string connector_name);
    
    string getConnectorName() const;

    void setDescription(string description);

    /**
     * String representation for saving to file.
     */
    string toString() const;

    /**
     * Returns the name of this module. The name depends on signal_type and wheter
     * the external_connector is a Signal or a Slot.
     */
    string getName() const;

    /**
     * Helper function for computing the module's name that can be called
     * from LMConnector as well.
     */
    static string getName(SignalType signal_type, bool external_signal);
};
