// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MConnector.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#include "MConnector.h"

class MGConnector : public ModuleGenerator
{
    SignalType signal_type;
    bool external_signal;
public:
    MGConnector(SignalType signal_type, bool external_signal) 
	: signal_type(signal_type), external_signal(external_signal) {};
    Module *create(string par) const { return new MConnector(signal_type, external_signal, par); };
    string getName() const { return MConnector::getName(signal_type, external_signal); };
};

MGConnector mg_connector_sound_signal(SOUND_TYPE,   true);
MGConnector mg_connector_sound_slot(SOUND_TYPE,     false);
MGConnector mg_connector_number_signal(NUMBER_TYPE, true);
MGConnector mg_connector_number_slot(NUMBER_TYPE,   false);
MGConnector mg_connector_text_signal(TEXT_TYPE,     true);
MGConnector mg_connector_text_slot(TEXT_TYPE,       false);

class ShortcutSignal : public Signal
{
    Slot *slot;
public:
    ShortcutSignal(SignalType signal_type, string name, string description, Module *module, Slot *slot)
	: Signal(signal_type, name, description, module) , slot(slot) {};
    PreparedSignal *prepareSignal(Metainfo *mi, const Parameterset *parset) 
	{ return slot->getPreparedSignal(this, mi, parset); };
};


MConnector::MConnector(SignalType signal_type, bool external_signal, string constructor_string)
{
    string connector_name, description;
    if (constructor_string =="")
    {
	connector_name = signal_type_name[signal_type];
	description = "Some parameter to set";
    }
    else {
      //connector_name = constructor_string.before(",");
      //description    = constructor_string.after(",");
      // FIXME:
      int p = constructor_string.find(",");
      connector_name   = constructor_string.substr(0,p);
      description      = constructor_string.substr(p,-1);
    }

    if (external_signal)
    {
	// TODO: Wirecolor!
	internal_connector = 
	    new Slot(signal_type,"ext-"+connector_name, "Connection to the outside",this,6);
	external_connector = new ShortcutSignal
	    (signal_type, connector_name, description, this, (Slot *)internal_connector);
    }
    else
    {
	external_connector = new Slot  (signal_type, connector_name, description, this,6);
	internal_connector = new ShortcutSignal
	    (signal_type, "ext-"+connector_name, "Connection to the outside", 
	     this, (Slot *)external_connector);
    }
    addConnector(internal_connector);
    addConnector(external_connector);
    external_connector->makeExternal(); // Will not appear in Wiremenu
}


void MConnector::setConnectorName(string name)
{
    external_connector->setName(name);
    internal_connector->setName("ext-" + name);
}


string MConnector::getConnectorName() const 
{ 
    return external_connector->getName(); 
}


MConnector::~MConnector()
{
}


string MConnector::toString() const
{
    return external_connector->getName() + "," + external_connector->getDescription();
}


string MConnector::getName() const
{
    return getName(internal_connector->getType(), external_connector->isSignal());
}


string MConnector::getName(SignalType signal_type, bool external_signal)
{
    return string("external-") 
	+ signal_type_name[signal_type]
	+ (external_signal ? "-signal" : "-slot");
}
