// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/looks/MLSetParameter.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/16 19:12:09 $
// $State: Exp $
// **************************************************************

#include "MSetParameter.h"
#include "LookMacros.h"
#include "EnterValueDialog.h"

class MLSetParameter : public ModuleLook
{
public:
    MLSetParameter(Module *module, ModuleLookGenerator *gen) : ModuleLook(module, gen) {};
    bool isControl() { return true; }; // see ModuleLook
    bool mousePressed(const QPoint&);
};


class MLGSetParameter : public ModuleLookGenerator
{
    SignalType parameter_signal_type;
    SignalType operand_signal_type;
public:
    MLGSetParameter(SignalType parameter_signal_type, SignalType operand_signal_type) 
	: parameter_signal_type(parameter_signal_type), operand_signal_type(operand_signal_type) {};
    ModuleLook *create(Module *module) { return new MLSetParameter(module, this); };
    string getName() const 
	{ return MSetParameter::getName(parameter_signal_type, operand_signal_type); };
    const char *menuPath() const { return "Parameters"; };
    QSize gridSize() const { return QSize(4,1); };

    void paint(QPainter&, Module *);
};

MLGSetParameter mlg_setParameter_sound_sound  (SOUND_TYPE,  SOUND_TYPE);
MLGSetParameter mlg_setParameter_sound_number (SOUND_TYPE,  NUMBER_TYPE);
MLGSetParameter mlg_setParameter_sound_text   (SOUND_TYPE,  TEXT_TYPE);
MLGSetParameter mlg_setParameter_number_sound (NUMBER_TYPE, SOUND_TYPE);
MLGSetParameter mlg_setParameter_number_number(NUMBER_TYPE, NUMBER_TYPE);
MLGSetParameter mlg_setParameter_number_text  (NUMBER_TYPE, TEXT_TYPE);
MLGSetParameter mlg_setParameter_text_sound   (TEXT_TYPE,   SOUND_TYPE);
MLGSetParameter mlg_setParameter_text_number  (TEXT_TYPE,   NUMBER_TYPE);
MLGSetParameter mlg_setParameter_text_text    (TEXT_TYPE,   TEXT_TYPE);


bool MLSetParameter::mousePressed(const QPoint&)
{
    MSetParameter *m = (MSetParameter *)getModule();
    string parametername = m->getParameterName();
    m->setParameterName(EnterValueDialog::getText("Enter name of parameter", parametername, "() "));
    return true; // graphical update neccessary.
}


void MLGSetParameter::paint(QPainter& p, Module *module)
{
    string text;
    
    if (module) text = ((MSetParameter *)module)->getParameterName();
    else text = "par";
    
    QRect textbox(QPoint(0,0), size()); // pos is in pixles
    p.setBackgroundColor(black);
    p.eraseRect(textbox);
    switch (parameter_signal_type) {
    case SOUND_TYPE:    p.setPen(QColor( 255,   31,    0)); break;
    case NUMBER_TYPE:   p.setPen(QColor(0x46, 0x82, 0xb4)); break;
    case TEXT_TYPE:     p.setPen(QColor(  21,  129,   16)); break;
    }
    p.drawText(textbox, AlignCenter | AlignVCenter, text.c_str());
}
