// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/rendering.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:37 $
// $State: Exp $
// **************************************************************

#include "rendering.h"
#include "gridspacing.h"

void paintBorder(QPainter& p, const QSize& s)
{
    p.save();
    p.setPen(QColor(208,208,208));
    p.drawRect(-1, -1, s.width()+2, s.height()+2); // very inner rectangle
    
    p.setPen(QColor(128,128,128)); // inner upper left
    p.moveTo(-2, s.height());
    p.lineTo(-2, -2);
    p.lineTo(s.width(), -2);
    
    p.setPen(black); // inner lower right
    p.moveTo(s.width()+1, -2);
    p.lineTo(s.width()+1, s.height()+1);
    p.lineTo(-2, s.height()+1);
    
    p.setPen(QColor(0x40, 0x40, 0x40)); // outer lower right
    p.moveTo(s.width()+2, -1);
    p.lineTo(s.width()+2, s.height()+2);
    p.lineTo(-1, s.height()+2);
    p.restore();
}

void paintRoundBorder(QPainter& p, const QSize& s, int roundness)
{
    p.save();

    p.setPen(QPen(QColor(0x40, 0x40, 0x40), 1)); // outer lower right
    p.drawRoundRect( 0,  0, s.width()+3, s.height()+3, roundness, roundness);

    p.setPen(QPen(black, 1)); // inner lower right
    p.drawRoundRect(-1, -1, s.width()+3, s.height()+3, roundness, roundness);

    p.setPen(QPen(QColor(128,128,128), 1)); // inner upper left
    p.drawRoundRect(-2, -2, s.width()+3, s.height()+3, roundness, roundness);
    
    p.setPen(QPen(QColor(208,208,208), 1));
    p.drawRoundRect(-1, -1, s.width()+2, s.height()+2, roundness, roundness);
    
    p.restore();
}

void paintSelection(QPainter& p, const QRect& rect)
{
    p.save();
    p.setBrush(QBrush(QColor(128, 128, 255), Dense5Pattern));
    p.setPen(QPen(QColor(128, 128, 255)));
    p.drawRect(rect);
    p.restore();
}


void paintRubberBorder(QPainter& p,  const QSize& s)
{
    p.save();
    p.setPen(QPen(black, 2, DotLine));
    p.drawRect(2, 2, s.width() - 2, s.height() - 2);
    p.setPen(QPen(white, 2, SolidLine));
    p.drawRect(2, 2, s.width() - 2, s.height() - 2);
    p.restore();
}


QRect sizeWithBorder(const QSize& s)
{
    return QRect(-4, -4, s.width()+8, s.height()+8);
}


QRect sizeWithRoundBorder(const QSize& s, int /* roundness */)
{
    return QRect(-4, -4, s.width()+8, s.height()+8);
}


void paintCanvas(QPainter& p, const QRect& r)
{
    p.save();
    p.setPen(NoPen);
    p.setBrush(QBrush(QColor(158,158,158)));
    p.drawRect(r);
    p.restore();
}

void paintGrid(QPainter& p, const QRect& r)
{
    p.save();
    p.setPen(QPen(QColor(80,80,80), 1, DotLine)); // TODO: don't hardcode color
    for (short x = r.left(); x <= r.right() ; x += GRID_SPACING) p.drawLine(x, 0, x, r.bottom());
    for (short y = r.top() ; y <= r.bottom(); y += GRID_SPACING) p.drawLine(0, y, r.right(), y);
    p.restore();
}

void paintAura(QPainter& p, const QRect& r)
{
    QColor auracolor(175,175,175);
    p.save();
    p.setBrush(QBrush(auracolor, SolidPattern));
    p.setPen(auracolor.dark(200));
    p.drawRect(r);
    p.restore();
}
