// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/Wirecell.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:36 $
// $State: Exp $
// **************************************************************

#include "Wirecell.h"
#include "gridspacing.h"

Wirecell::Wirecell() 
{ 
    a_colormask[to_the_right] = 0; 
    a_colormask[to_the_bottom] = 0; 
}

    
bool Wirecell::isFree(Direction direction, Colormask colormask) const
{ 
    return (a_colormask[direction] & colormask) == 0; 
}

 
void Wirecell::enter(Direction direction, Colormask colormask) 
{ 
    a_colormask[direction] |= colormask; 
}


void Wirecell::remove(Direction direction, Colormask colormask)
{ 
    a_colormask[direction] &= ~colormask; 
}


Colormask Wirecell::getColormask(short color) 
{
    return 1 << (color % NUMBER_WIRE_COLORS); 
}


void Wirecell::paint(QPainter& p, short xoffset, short yoffset)
{
    short center_x = xoffset + GRID_SPACING / 2;
    short center_y = yoffset + GRID_SPACING / 2;
    if (a_colormask[to_the_right])
    {
	short color;
	for (color=0; color<NUMBER_WIRE_COLORS; color++)
	    if (a_colormask[to_the_right] & (1 << color)) break;
	drawWire(p, center_x, center_y, center_x + GRID_SPACING, center_y, color);
    }
    if (a_colormask[to_the_bottom])
    {
	short color;
	for (color=0; color<NUMBER_WIRE_COLORS; color++)
	    if (a_colormask[to_the_bottom] & (1 << color)) break;
	drawWire(p, center_x, center_y, center_x, center_y + GRID_SPACING, color);
    }
}


void Wirecell::drawWire(QPainter& p, short x1, short y1, short x2, short y2, short color)
{
    static QColor a_color[NUMBER_WIRE_COLORS] = 
    { 
	QColor(193,  11,  11),
	QColor(255,  50,  35),
	QColor(255, 138,  29),
	QColor(255, 191,  29),
	QColor(255, 255,   0),
	QColor( 99, 195,  31),
	QColor( 68, 217, 205),
	QColor(164, 132,  73),

	QColor(  0, 170, 226),
	QColor( 53,  76, 226),
	QColor(134,  41, 188),
	QColor(212,  22, 152),
	QColor(250, 135, 214),
	QColor(  0, 128, 128),
	QColor( 31, 144,  14),
	QColor( 29, 195, 129)
    };

    color %= NUMBER_WIRE_COLORS;

    bool smallwire = color >= NUMBER_WIRE_COLORS/2;
    short thickness = smallwire ? 1 : 2;

    QColor wirecolor = (color < NUMBER_WIRE_COLORS) ? a_color[color] : black;
    p.setPen(QPen(black,                thickness));
    p.drawLine(x1+1, y1+1, x2+1, y2+1);
    p.setPen(QPen(wirecolor.light(180), thickness));
    p.drawLine(x1-1, y1-1, x2-1, y2-1);
    p.setPen(QPen(wirecolor,            thickness));
    p.drawLine(x1,   y1,   x2,   y2);
}
