// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/SplashScreen.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:36 $
// $State: Exp $
// **************************************************************

#include "SplashScreen.h"
#include "SplashScreen-moc.h"
#include "SplashScreen.xpm"
#include "AboutButton.xpm"
#include "HelpButton.xpm"
#include "ExamplesButton.xpm"

#include <qlayout.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qpushbutton.h>

class PixmapButton : public QPushButton
{
    QPixmap pixmap;
public:
    PixmapButton(QWidget *parent, QPixmap pixmap) :
	QPushButton(parent), pixmap(pixmap) { setMinimumSize(sizeHint()); };
protected:
    void drawButtonLabel(QPainter *p) { p->drawPixmap(3, 3, pixmap); };
    QSize sizeHint() const { return pixmap.size() + QSize(6, 6); };
};


SplashScreen::SplashScreen(QWidget *parent)
    : QWidget(parent)
    , splash_pixmap((const char **)SplashScreen_xpm)
    , about_pixmap((const char **)AboutButton_xpm)
    , help_pixmap((const char **)HelpButton_xpm)
    , examples_pixmap((const char **)ExamplesButton_xpm)
{
    QLabel *l_image = new QLabel("", this);
    l_image->setPixmap(splash_pixmap);
    l_image->setMinimumSize(l_image->pixmap()->size());
    resize(l_image->minimumSize());


    QVBoxLayout *toplayout = new QVBoxLayout(this, 4, 4);
    toplayout->addStretch(1);

    QHBoxLayout *buttons = new QHBoxLayout();
    toplayout->addLayout(buttons);
    PixmapButton *b_about    = new PixmapButton(this, about_pixmap);
    PixmapButton *b_help     = new PixmapButton(this, help_pixmap);
    PixmapButton *b_examples = new PixmapButton(this, examples_pixmap);
    connect(b_about,    SIGNAL(clicked()), this, SLOT(about_clicked()));
    connect(b_help,     SIGNAL(clicked()), this, SLOT(help_clicked()));
    connect(b_examples, SIGNAL(clicked()), this, SLOT(examples_clicked()));

    buttons->addWidget(b_about, 0);
    buttons->addStretch(1);
    buttons->addWidget(b_help, 0);
    buttons->addStretch(1);
    buttons->addWidget(b_examples, 0);
    toplayout->activate();
}

void SplashScreen::about_clicked()
{
    emit about();
}


void SplashScreen::help_clicked()
{
    emit help();
}

void SplashScreen::examples_clicked()
{
    emit examples();
}
