// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ModuleLook.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#include <qpopupmenu.h>

#include "Slot.h"
#include "Signal.h"
#include "Module.h"
#include "SignalTypes.h"
#include "ModuleLook.h"
#include "Wirecell.h"
#include "rendering.h"
#include "ModuleLookGenerator.h"

#include "sound_slot.xpm"
#include "sound_signal.xpm"
#include "number_slot.xpm"
#include "number_signal.xpm"
#include "text_slot.xpm"
#include "text_signal.xpm"

ModuleLook::ModuleLook(Module *module, ModuleLookGenerator *generator)
    : module(module)
    , generator(generator)
{
}

Module *ModuleLook::getModule() const { return module; }

QSize   ModuleLook::gridSize()  const { return generator->gridSize(); };
short   ModuleLook::gridLeft()  const { return module->gridLeft(); }
short   ModuleLook::left()      const { return gridLeft() * GRID_SPACING; }
short   ModuleLook::gridTop()   const { return module->gridTop(); }
short   ModuleLook::top()       const { return gridTop() * GRID_SPACING; }
QPoint  ModuleLook::gridPos()   const { return QPoint(gridLeft(), gridTop()); }
QPoint  ModuleLook::pos()       const { return gridPos() * GRID_SPACING; }
QRect   ModuleLook::gridRect()  const { return QRect(gridPos(), gridSize()); }
QRect   ModuleLook::rect()      const { return QRect(pos(), size()); }
QPoint  ModuleLook::center()    const { return rect().center(); }

QRect ModuleLook::sizeWithBorder() const
{
    return generator->sizeWithBorder();
}

QRect ModuleLook::rectWithBorder() const
{
    QRect rect = sizeWithBorder();
    rect.moveBy(left(), top());
    return rect;
}

QRect ModuleLook::rectOfAura() const 
{ 
    short l = ((left() - width()  / 2) / GRID_SPACING) * GRID_SPACING;
    short t = ((top()  - height() / 2) / GRID_SPACING) * GRID_SPACING;
    return QRect(l, t, 1 + width() * 2, 1 + height() * 2);
}

void ModuleLook::gridMove(const QPoint& vector) 
{
    gridMoveTo(gridPos() + vector); 
}


void ModuleLook::gridMoveTo(const QPoint& gridpos) 
{ 
    module->moveTo(gridpos.x(), gridpos.y()); 
}


bool ModuleLook::intersects(const QRect& rect) const
{
    return rect.intersects(rectWithBorder());
}

bool ModuleLook::needsRepaint()
{ 
    return false;
}

void ModuleLook::paintAura(QPainter& p) const
{
    ::paintAura(p, rectOfAura());
}

void ModuleLook::paint(QPainter& p)
{
    generator->paint(p, getModule());
}

void ModuleLook::paintBorder(QPainter& p) const
{
    generator->paintBorder(p);
}

void ModuleLook::paintSelection(QPainter& p) const
{
    generator->paintSelection(p);
}


const char **signal_type_pixmap[NUMBER_SIGNAL_TYPES][2] =
{
    { (const char **)sound_slot_xpm,  (const char **)sound_signal_xpm  },
    { (const char **)number_slot_xpm, (const char **)number_signal_xpm },
    { (const char **)text_slot_xpm,   (const char **)text_signal_xpm   }
};


QPopupMenu *ModuleLook::createWireMenu(Connector *connector) const
{
    // If connector is not 0 this means, that the user is already
    // wireing and just pops up the menu for the destination of the wire.
    // Furthermore he selected the same Module as for the source. If he
    // is wireing a slot, then he must select this slot another time to
    // define is parameter slot. 

    QPopupMenu *menu = new QPopupMenu();
    menu->setCheckable(false);

    // From module get information about connectors
    Connector * const *a_connector = module->connectorTable();
    bool first_entry = true;
    for (int slot_signal=0; slot_signal<=1; slot_signal++) // First slots, than signals.
    {
	bool is_signal = slot_signal == 1;
	for (int id=0; id<module->numberConnectors(); id++) 
	{
	    // Don't show external connectors. External connectors may be
	    // connectors of two modules! They are connectors of a Module
	    // of the type external-{sound|number|text}-{slot|signal} and
	    // may be connectors of the MacroModule that contains this
	    // Module. An external connector may only appear in the wire menu
	    // of that "outer" MacroModule.

	    if (a_connector[id]->isExternalTo(getModule())) continue;

	    if (is_signal == a_connector[id]->isSignal())
	    {
		if (first_entry) first_entry = false;
		else  menu->insertSeparator();
		
		menu->insertItem(createWireMenuPixmap
				 (is_signal, a_connector[id]->getType(), 
				  is_signal ? false : ((Slot *)a_connector[id])->isConnected(),
				  is_signal ? false : ((Slot *)a_connector[id])->isParameter(),
				  a_connector[id] == connector,
				  a_connector[id]->getName(), a_connector[id]->getDescription(),
				  is_signal ? -1 : ((Slot *)a_connector[id])->getWireColor()),
				 id);
	    }
	}
    }
    return menu;
}


QPixmap ModuleLook::createWireMenuPixmap(bool signal_and_not_slot, SignalType type,
					       bool is_connected, bool is_parameter,
					       bool select_for_parameter,
					       string name, string description, short wirecolor) const
{
    QPainter p;

    // short fontheight = p.fontMetrics().height();
    const short fontheight = 11;
    const short width = 240;

    QPixmap pixmap(width, 2 * fontheight + 8 + (select_for_parameter ? fontheight + 4 : 0));
    pixmap.fill(QColor(160,160,160));
    p.begin(&pixmap);
    QFontMetrics fontmetrics = p.fontMetrics();
    short width_of_name = fontmetrics.width(name.c_str());
    
    QPixmap icon(signal_type_pixmap[type][signal_and_not_slot ? 1 : 0]);
    p.drawPixmap(3, 3, icon);

    p.setPen(white);
    p.drawText(30, fontheight, name.c_str());
    p.setPen(black);
    p.drawText(30, 4 + 2 * fontheight, description.c_str());
    if (is_parameter)
    {
	p.setPen(yellow);
	p.drawText(width - fontmetrics.width("parameter!") - 5, 
		   fontheight, "parameter!"); // TODO: l_PARAMETER
    }
    else if (is_connected && wirecolor >= 0) 
	Wirecell::drawWire(p, 30 + 4 + width_of_name, 7, width-5, 7, wirecolor);
    
    if (select_for_parameter) {
	p.setPen(yellow);
	p.drawText(30, 8 + 3 * fontheight, "Select to define this slot as parameter");
    }
    
    p.end();
    return pixmap;
}
