// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/LayoutElement.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#ifndef LayoutElement_h
#define LayoutElement_h

#include <qpainter.h>

#include "gridspacing.h"

/**
 * @short Something you can paint and that has a size. You can paint it only
 * at 0,0. It has no position.
 */
class LayoutElement
{
public:
    virtual ~LayoutElement() {};
    virtual QSize gridSize()                       const = 0;
    virtual QRect sizeWithBorder()                 const = 0;
    virtual void  paint(QPainter& p)                     = 0;
    virtual void  paintBorder(QPainter& p)         const = 0;
    virtual void  paintSelection(QPainter& p) const = 0;

    // conveniant shortcut functions 
    short  gridWidth()  const { return gridSize().width(); };
    short  gridHeight() const { return gridSize().height(); };
    QSize  size()       const { return gridSize()   * GRID_SPACING; };
    short  width()      const { return gridWidth()  * GRID_SPACING; };
    short  height()     const { return gridHeight() * GRID_SPACING; };
    QPixmap getPixmap();
};


#endif // LayoutElement_h
