// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ESWireing.cc,v $
// $Revision: 1.2 $
// $Date: 1999/05/16 19:14:53 $
// $State: Exp $
// **************************************************************

#include <qcursor.h>

#include "ESWireing.h" 
#include "ESWireing-moc.h"
#include "ESNothing.h"
#include "ModuleLook.h"
#include "MacroModuleLook.h"


ESWireing::ESWireing(MacroModuleLook *mml, ModuleLook *module_look, Connector *connector)
    : EditorState(mml)
    , module_look(module_look)
    , connector(connector)
    , mouse_position(module_look->center())
{
}

void ESWireing::enter()
{
    mml->setMouseTracking(TRUE);
    draw();
}

void ESWireing::leave()
{
    draw();
    mml->setMouseTracking(FALSE);
}

void ESWireing::paintEvent(QPainter& p, const QRect&)
{
    p.save();
    draw(p);
    p.restore();
}

void ESWireing::draw() const
{
    QPainter *p = new QPainter();
    p->begin(mml->widget());
    draw(*p);
    p->end();
    delete p;

}

void ESWireing::draw(QPainter& p) const
{
    QPoint start = module_look->center();
    p.setRasterOp(XorROP);
    p.setPen(QPen(white, 2, SolidLine));
    p.drawLine(start, mouse_position);
}

EditorState *ESWireing::mouseMoved(const QMouseEvent *event)
{
    draw();
    mouse_position = event->pos();
    draw();
    return this;
}

EditorState *ESWireing::leftButtonPressed(const QMouseEvent *)
{
    return new ESNothing(mml);
}


EditorState *ESWireing::middleButtonPressed(const QMouseEvent *e)
{
    ModuleLook *ml = mml->findModuleLookAt(e->pos());
    if (ml) mml->popupWireMenu(ml, connector);
    return this;
}
