// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/Annotation.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:34 $
// $State: Exp $
// **************************************************************

#ifndef Annotation_h
#define Annotation_h

// #include <qstring.h>
// #include <qpoint.h>
#include <qpainter.h>


/**
  * @short Kind of ballon help, which points to errors and explains them to the user.
  */
class Annotation
{
public:
    enum Type { ERROR, WARNING, INFO };
public:
    Annotation(const char *, const char *, Type, const QPoint&, const QPoint &);
    void paint(QPainter &) const;
    QRect rect() const; // minimal enclosing rectangle
    bool intersects(const QRect& r)      const { return rect().intersects(r); };
    bool mouseClickHits(const QPoint &p) const { return balloon_area.contains(p); };
    void rightMouseClicked();
private:
    QString title;
    QString text;
    Type type;
    QPoint anchor;
    QFont title_font;
    QFont text_font;

    QRect title_area;
    QRect text_area;
    QRect balloon_area;
};

#endif // Annotation_h
