// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/Annotation.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:34 $
// $State: Exp $
// **************************************************************

#include <qpixmap.h>
#include "Annotation.h"

Annotation::Annotation(const char *tt, const char *tx, Type ty,
		       const QPoint& pos, const QPoint &ac) :
    title(tt),
    text(tx),
    type(ty),
    anchor(ac),
    title_font("Helvetica",14, QFont::Bold),
    text_font("Helvetica",12, QFont::Normal)
{
    QPainter painter;
    QPixmap  dummypixmap(1,1);
    painter.begin(&dummypixmap);
    painter.setFont(title_font);
    title_area = painter.boundingRect(pos.x(), pos.y(), 220, 500, WordBreak, title);
    painter.setFont(text_font);
    text_area = painter.boundingRect(pos.x(), title_area.bottom()+8, 220, 800, WordBreak, text);

    const int border = 8;
    balloon_area = QRect(pos.x() - border, pos.y() - border,
			 text_area.right() - pos.x() + 2 * border,
			 text_area.bottom() - pos.y() + 2 * border);
    painter.end();
}


#include "pin.xpm"
#define PIN_X_SIZE   28
#define PIN_Y_SIZE   24
#define PIN_Y_OFFSET 20 // hotspot ...
#define PIN_X_OFFSET 12 // .. of pin

void Annotation::paint(QPainter& p) const
{
    static QPixmap pixmap((const char **)pin_xpm); // Make it static. Loading lasts long.

    p.save();
    p.eraseRect(balloon_area);
    p.setFont(title_font);
    p.setPen(blue);
    p.drawText(title_area, WordBreak, title);
    p.setFont(text_font);
    p.setPen(black);
    p.drawText(text_area, WordBreak, text);

    p.setPen(QPen(gray, 1, SolidLine));
    p.drawRect(balloon_area);
    p.setPen(QPen(gray, 2, SolidLine));
    p.drawLine(balloon_area.topLeft(), anchor);
    p.drawPixmap(anchor.x() - PIN_X_OFFSET, anchor.y() - PIN_Y_OFFSET, pixmap);
    p.restore();
}


QRect Annotation::rect() const
{
    return balloon_area.unite(QRect(QPoint(anchor.x() - PIN_X_OFFSET,
					   anchor.y() - PIN_Y_OFFSET),
				    QSize(PIN_X_SIZE,
					  PIN_Y_SIZE)));
}


void Annotation::rightMouseClicked()
{
    // Context menu
}
