// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/SharedSoundStore.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:37 $
// $State: Exp $
// **************************************************************

#ifndef SharedSoundStore_h
#define SharedSoundStore_h

#include "SharedStore.h"
#include "BasicTypes.h"

/** A SharedSoundStore is an array of sound data, that is not stored in the
  * cache but only referenced by SoundPortion. It realizes a kind of automatic
  * memory management similar to the classes String and StringRep.
  */
class SharedSoundStore : public SharedStore
{
    Number *data;
    long   reference_counter;
public:
    SharedSoundStore(Number *d) : data(d), reference_counter(0) {};
    ~SharedSoundStore() { delete data; };
    void reference()   { reference_counter++; };
    void unreference() { if (--reference_counter == 0) { delete this; } };
};

#endif // SharedSoundStore_h
