#ifndef PNSigStoredNumber_h
#define PNSigStoredNumber_h

#include "PreparedNumberSignal.h"

/**
 * Generic PreparedNumberSignal, for number signals, where
 * the current value of the signal is stored in a variable
 * of type Number. This does not mean that the number
 * must be constant. But it means, that no further data
 * can be aquired from any slot to compute the number.
 * For example MNumber uses this class.
 */
class PNSigStoredNumber : public PreparedNumberSignal
{
    Number *value;
public:
    /**
     * @param Number A pointer to the variable holding
     * the value of this Signal.
     */
    PNSigStoredNumber(Number *value) : value(value) {};
    Number getNumber() { return *value; };
};

#endif // PNSigStoredNumber_h
