// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/OutputModuleFile.cc,v $
// $Revision: 1.3 $
// $Date: 1999/05/16 19:14:50 $
// $State: Exp $
// **************************************************************

#include <stdio.h>

#include "OutputModuleFile.h"
#include "Module.h"
#include "Wire.h"
#include "Slot.h"
#include "Signal.h"
#include "version.h"

OutputModuleFile::OutputModuleFile(const char *filename)
    : output(filename)
{
    if (output.good()) {
	writeLine("#!/opt/kde/bin/m3player");
	writeLine(VERSION_STRING);
	writeLong(compatibility_level);
	writeLong(MAJOR_VERSION);
	writeLong(MINOR_VERSION);
	writeLong(REVISION);
    }
}

void OutputModuleFile::writeLine(string str)
{
    output << str << endl;
}

void OutputModuleFile::writeLong(long l)
{
    output << l << endl;
}

void OutputModuleFile::writeDouble(double d)
{
    output << d << endl;
}


void OutputModuleFile::beginWritingModules(long number)
{
    output << "Submodules: " << number << endl;
}


void OutputModuleFile::writeModule(const Module *module)
{
    // prepare Parameterslots
    string parameterslots = "(";
    Connector * const *a_connector = module->connectorTable();
    bool first_entry = true;
    for (int c=0; c < module->numberConnectors(); c++) 
    {
	if (a_connector[c]->isSlot() && ((Slot *)a_connector[c])->isParameter()) {
	    if (first_entry) first_entry = false;
	    else  parameterslots += ",";
	    parameterslots += a_connector[c]->getName();
	}
    }
    parameterslots += ")";

    // prepare Module's parameter string.
    string parameter = "(" + module->toString() + ")";

    char *line = 
	new char [128 + parameter.length() + module->getName().length() + parameterslots.length()];

    sprintf(line, "%3d:%-20s%-15s at %2d,%2d %s par %s\n",
	    module->getID(), module->getName().c_str(), parameter.c_str(), 
	    module->gridLeft(), module->gridTop(), 
	    module->isVisible() ? "visible  " : "invisible", parameterslots.c_str());

    output << line;
    delete line;
}	


void OutputModuleFile::beginWritingWires(long number)
{
    output << "Wires: " << number << endl;
}


void OutputModuleFile::writeWire(const Wire *wire)
{
    char *line = new char[128 + wire->getSignal()->getName().length() 
			 + wire->getSlot()->getName().length()];

    sprintf(line, "%d.%s -> %d.%s\n",
	    wire->getSignalModule()->getID(),
	    wire->getSignal()->getName().c_str(),
	    wire->getSlotModule()->getID(),
	    wire->getSlot()->getName().c_str());
    output << line;
    delete line;
}


inline char ntoh(int n)
{
    return (n < 10 ? n + '0' : n - 10 + 'A');
}


void OutputModuleFile::writeByteBlock(const char *comment, const unsigned char *block, long length)
{
    output << "Byteblock \"" << comment << "\" " << length << endl;
    char *buffer = new char[length * 2 + 1];
    char *w = buffer;

    for (long i=0; i < length; i++)
    {
	*w++ = ntoh(*block >> 4);
	*w++ = ntoh(*block++ & 0x0f);
    }
    *w = 0;
    output.write(buffer, length * 2);
    output << endl;
    delete buffer;
}

bool OutputModuleFile::writeByteBlock(const char *comment, const char *filename)
{
    FILE *file = fopen(filename, "r");
    if (file) {
	fseek(file, 0, SEEK_END);
	unsigned long size = ftell(file);
	rewind(file);
	unsigned char *block = new unsigned char[size];
	bool success = (size == fread(block, 1, size, file));
	if (success) writeByteBlock(comment, block, size);
	fclose(file);
	delete block;
	return success;
    }
    return false;
}


void OutputModuleFile::writePixmap(const char *comment, const LIPixmap& pixmap)
{
    writeByteBlock(comment, pixmap.imagedata, pixmap.imagesize);
}

void OutputModuleFile::writeLookInfo(const LookInfo& look_info)
{
    writeLine(look_info.name); // Modules name comes first
    writeLine(look_info.description);

    writePixmap("preview", look_info.preview);

    char line[256];
    sprintf(line, "Look: %08X bgcolor(%d,%d,%d) textcolor(%d,%d,%d) rect(%d,%d,%d,%d)",
	    (look_info.text_layout   ? 0x00000001 : 0) |
	    (look_info.image_layout  ? 0x00000002 : 0) |
	    (look_info.separators    ? 0x00000004 : 0) |
	    (look_info.threed_border ? 0x00000008 : 0) |
	    (look_info.rounded_edges ? 0x00000010 : 0),
	    look_info.backgroundcolor.r, 
	    look_info.backgroundcolor.g,
	    look_info.backgroundcolor.b,
	    look_info.textcolor.r, 
	    look_info.textcolor.g, 
	    look_info.textcolor.b,
	    look_info.layout_rect.left,
	    look_info.layout_rect.top,
	    look_info.layout_rect.width,
	    look_info.layout_rect.height);
    writeLine(line);

    if (look_info.text_layout)  writeLine(look_info.layout_text);
    if (look_info.image_layout) writePixmap("background image", look_info.image);
}


void OutputModuleFile::writeEditorInfo(const EditorInfo& editorinfo)
{
    char line[128];
    sprintf(line, "Editor: %08lx %dx%d",
	    (long unsigned int)editorinfo.edit_look ? 0x00000001L : 0L,
	    editorinfo.canvas_width,
	    editorinfo.canvas_height);
    writeLine(line);
}
