// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Module.cc,v $
// $Revision: 1.3 $
// $Date: 1999/05/16 19:14:50 $
// $State: Exp $
// **************************************************************

#include "Module.h"
#include "Connector.h"
#include "ModuleErrorReport.h"
#include "toString.h"

Module::Module() 
    : number_connectors(0)
    , id(0)
    , error_report(0) 
    , is_visible(false)
    , selected(false)
{
}


Module::~Module()
{
  for (unsigned short c=0; c < number_connectors; c++) delete a_connector[c];
  if (error_report) delete error_report;
}

void Module::moveTo(short left, short top)
{
    grid_left = left;
    grid_top  = top;
}

short Module::gridLeft() const
{
    return grid_left;
}


short Module::gridTop() const
{
    return grid_top;
}


bool Module::isVisible() const 
{ 
    return is_visible; 
}

void Module::setVisibility(bool visible) 
{ 
    is_visible = visible; 
}


bool Module::isSelected() const
{
    return selected;
}


void Module::select(bool yesno)
{
    selected = yesno;
}


string Module::addConnector(Connector *c)
{
    if (connectorNamed(c->getName())) 
	return string("A connector with name '" + c->getName() + "' already exists");
    else if (number_connectors >= MAX_NUMBER_CONNECTORS)
	return string("Sorry, each module can have only " + ::toString(MAX_NUMBER_CONNECTORS) 
		      + " connectors");
    else {
	a_connector[number_connectors++] = c;
	return "";
    }
}

void Module::removeConnector(Connector *connector)
{
    for (unsigned short c=0; c < number_connectors; c++)
    {
	if (a_connector[c] == connector) {
	    // Shift all connectors with higher indices one index down.
	    for (unsigned short d=c+1; d < number_connectors; d++)
		a_connector[d-1] = a_connector[d];
	    number_connectors--;
	    return;
	}
    }
    fprintf(stderr, "Internal error: removeConnector() couldn't find connector %s %lx of Module %s.\n", 
	    connector->getName().c_str(), (unsigned long)connector, getName().c_str());
}


Connector * const *Module::connectorTable() const
{
    return a_connector;
}


unsigned short Module::numberConnectors() const
{
    return number_connectors;
}


Connector *Module::connectorNamed(string name) const
{
    for (unsigned short c=0; c < number_connectors; c++) 
	if (a_connector[c]->getName() == name) return a_connector[c];
    return 0;
}

string Module::nameOfConnector(unsigned short id) const
{
    return connectorNumber(id)->getName(); 
}


void Module::reportError(const char *title, const char *text)
{
    if (!error_report) // only one error report allowed
	error_report = new ModuleErrorReport(title, text);
}


ModuleErrorReport *Module::getErrorReport()
{
    ModuleErrorReport *result = error_report; // caller has to delete!
    error_report = 0;
    return result;
}
