// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/Generator.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:35 $
// $State: Exp $
// **************************************************************

#ifndef Generator_h
#define Generator_h

#include <string>

#include "DLList.h"

/**
  * 
  */
template<class T> class Generator : public DLListNode
{
    short unique_id;

    static const unsigned long list_initialized_magic = 0xdeadbeef;
    static unsigned long list_initialized;
    static short actual_id;
    static bool listInitialized() { return list_initialized == list_initialized_magic; };
    static void initializeList() {
	generator_list = new DLList;
	list_initialized = list_initialized_magic;
    };
protected:
    static DLList *generator_list;

public:
    Generator () {
	if (!listInitialized()) {
	    initializeList();
	    actual_id = 1;
	}
	unique_id = actual_id++;
	generator_list->addLast(this);
    };
    virtual ~Generator() {};
    virtual string getName() const = 0;
    short uniqueId() const { return unique_id; };

    static const DLList *generatorList() { return listInitialized() ? generator_list : 0; };
    static Generator<T> *findGenerator(const char *name) {
	if (!listInitialized()) return 0;
	DLListNode *node = generator_list->getFirst();
	while (!generator_list -> isEndOfList(node)) {
	    if (!strcmp(((Generator<T> *)node)->getName().c_str(), name)) return (Generator<T> *)node;
	    node = node->getNext();
	}
	return 0;
    };
    static Generator<T> *findGenerator(short id) {
	if (!listInitialized()) return 0;
	DLListNode *node = generator_list->getFirst();
	while (!generator_list -> isEndOfList(node)) {
	    if (id == ((Generator<T> *)node)->uniqueId()) return (Generator<T> *)node;
	    node = node->getNext();
	}
	return 0;
    };
    static string allNames() {
	string allnames = "";
	if (listInitialized()) {
	    DLListNode *node = generator_list->getFirst();
	    while (!generator_list->isEndOfList(node)) {
		allnames = allnames + ((Generator *)node)->getName() + "\n";
		node = node->getNext();
	    }
	}
	return allnames;
    };
};


#endif // Generator_h
