// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/DirScan.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:35 $
// $State: Exp $
// **************************************************************

#include <dirent.h>
#include <sys/stat.h>

#include "DirScan.h"

DirScan::DirScan(string rootdir_name)
    : rootdir_name(rootdir_name)
    , current_dir(opendir(rootdir_name.c_str()))
    , current_entry(0)
    , current_sub_dir(0)
{
}


DirScan::~DirScan()
{
    if (current_sub_dir) delete current_sub_dir;
    if (current_dir) closedir(current_dir);
}


bool DirScan::toNext()
{
    if (!current_dir) return false;
    if (current_sub_dir) { // currently scanning subdir
	if (current_sub_dir->toNext()) return true;
	else {
	    delete current_sub_dir; // finished scanning subdir
	    current_sub_dir = 0;
	}
    }
    
    current_entry = readdir(current_dir);
    if (!current_entry) { // No more entry
	closedir(current_dir);
	current_dir = 0;
	return false;
    }

    // Ignore '.' and '..'
    if (!strcmp(current_entry->d_name, ".")
	|| !strcmp(current_entry->d_name, "..")) return toNext();

    if (isDirectory(rootdir_name + "/" + current_entry->d_name)) {
	current_sub_dir = new DirScan(rootdir_name + "/" + current_entry->d_name);
	current_subdir_name = current_entry->d_name;
	return toNext();
    }
    return true;
}


string DirScan::relativeDirPath() const
{
    if (!current_sub_dir) return "";
    else {
	string subdirpath = current_sub_dir->relativeDirPath();
	if (subdirpath.length() > 0)
	    return current_subdir_name + "/" + subdirpath;
	else return current_subdir_name;
    }
}


string DirScan::fullFilename() const
{
    // rootfile_name + "/" + relativeDirPath() + "/" + fileName()
    
    string reldirpath = relativeDirPath();
    if (reldirpath.length() > 0) return rootdir_name + "/" + reldirpath + "/" + fileName();
    else return rootdir_name + "/" + fileName();
}


// helper functions
string DirScan::fileName() const
{
    if (current_sub_dir) return current_sub_dir->fileName();
    else if (current_dir && current_entry) return current_entry->d_name;
    else return ""; // error!
}


bool DirScan::isDirectory(string filename) const
{
    struct stat filestat;
    if (!stat(filename.c_str(), &filestat))
    {
	return S_ISDIR(filestat.st_mode);
    }
    else return false;
}


