/**************************************************************************

    songlist.cc  - class SongList, which holds a list of songs (collection)
    This file is part of KMid 1.7 
    Copyright (C) 1997,98,99,2000  Antonio Larrosa Jimenez
    KMid's homepage : http://www.arrakis.es/~rlarrosa/kmid.html            

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to Antonio Larrosa <larrosa@kde.org>

***************************************************************************/
#include "songlist.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

SongList::SongList(void)
{
  list=0L;
  last=0L;
  active=0L;
  ntotal=0;
}

SongList::SongList(SongList &src)
{
  list=last=active=0L;
  ntotal=0;
  src.iteratorStart();
  while (!src.iteratorAtEnd())
  {
    addSong(src.iteratorName());
    src.iteratorNext();
  }
  if (src.active!=0L) active=songID(src.active->id);
}

SongList::~SongList()
{
  clear();
  Song *ptr=list;
  active=last=0L;
  ntotal=0;

  while (ptr!=0L)
  {
    list=ptr->next;
    delete ptr->name;
    delete ptr;
    ptr=list;
  }

}

SongList::Song *SongList::songID(int id)
{
  Song *ptr=list;
  while ((ptr!=0L)&&(ptr->id!=id))
    ptr=ptr->next;

  return ptr;
}

int SongList::addSong(const char *song)
{
  if (last==0L)
  {
    last=new Song;
    list=last;
  }
  else
  {
    last->next=new Song;
    last=last->next;
  }
  last->name=new char[strlen(song)+1];
  strcpy(last->name,song);
  last->id= ++ntotal;
  last->next=0L;
  if (active==0L) active=last;
  return last->id;
}

void SongList::delSong(int id)
{
  Song *ptr;

  if (list==0L) return;
  if (id==1)
  {
    if (last->id==1)
    {
      list=last=active=0L;
      ntotal=0;
    }
    else
    {
      ptr=list;
      if (active->id==1) active=list->next;
      list=list->next;
      delete ptr->name;
      delete ptr;
      ntotal--;

      regenerateID(list,1);
    }
    return;
  }
  Song *ptr_prev=songID(id-1);
  ptr=ptr_prev->next;
  if (last->id==id) last=ptr_prev;
  if (active->id==id) 
    if (active->next!=0L) active=active->next;
    else active=ptr_prev;

    ntotal--;
    ptr_prev->next=ptr->next;
    delete ptr->name;
    delete ptr;
    regenerateID(ptr_prev->next,id);

}

void SongList::regenerateID(Song *song,int id)
{
  Song *tmp=song;
  int i=id;
  while (tmp!=0L)
  {
    tmp->id=i++;
    tmp=tmp->next;
  }
  ntotal=i-1;
}

void SongList::setActiveSong(int id)
{
  Song *tmp=songID(id);
  if (tmp!=0L) active=tmp;
}

char *SongList::songName(int id)
{
  Song *tmp=songID(id);
  if (tmp!=0L) return tmp->name;
  return 0L;
}

void SongList::iteratorStart(void)
{
  it=list;
}

void SongList::iteratorNext(void)
{
  if (it!=0L) it=it->next;
}

int SongList::iteratorID(void)
{
  if (it==0L) return -1;
  return it->id;
}

char *SongList::iteratorName(void)
{
  if (it==0L) return 0L;
  return it->name;
}


void SongList::clear(void)
{
  Song *tmp=list;
  active=last=0L;
  ntotal=0;

  while (tmp!=0L)
  {
    list=tmp->next;
    delete tmp->name;
    delete tmp;
    tmp=list;
  }
}

void SongList::copy(SongList &src)
{
  clear();
  src.iteratorStart();
  while (!src.iteratorAtEnd())
  {
    addSong(src.iteratorName());
    src.iteratorNext();
  }
  if (src.active!=0L) active=songID(src.active->id);
}

int SongList::next(void)
{
  if (list==0L) {active=0L;return 0;};
  if (active!=0L) active=active->next;
  if (active==0L) 
  {
    Song *tmp=list;
    while (tmp->next!=0L) tmp=tmp->next;
    active=tmp;
    return 0;
  }
  return 1;
}


void SongList::previous(void)
{
  if (list==0L) {active=0L;return;};
  Song *tmp=list;
  while ((tmp->next!=0L)&&(tmp->next->id!=active->id)) tmp=tmp->next;
  if (tmp->next==0L) {active=list;return;};
  active=tmp;
}
