	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _SYNTH_IMPL_H
#define _SYNTH_IMPL_H

#include "synth.h"
#include "synthmodule.h"
#include "moduleserver.h"

#ifdef HAVE_MINI_STL
#include <ministl/list>
#include <ministl/string>
#else
#include <list>
#include <string>
#endif

class KSynthIOEvent;

class KSynthesizer_impl :virtual public KSynthesizer_skel
{
	#define ARG_WRITE	1
	#define ARG_READ	2
	#define ARG_CONST	4

	class Arg {
	public:
		Arg();			// only there to make it work with ministl

		Arg(string name, int flags, float *memory);

		float *memory;  // where the argument will be stored later
		string name;
		int flags;	   // combination of ARG_READ, ARG_WRITE, ARG_CONST
	};

	list<Arg> ArgList;

	SynthModule	**SynthModules;
	int MCount;

	list<KSynthIOEvent *> IOEvents;

protected:
	ModuleServer<SynthModule> *MS_SynthModule;
	float *AllocArg(string name, int flags);

	// Script commands. Might become CORBA commands one nice day ;)
	void Execute_Create(char *buffer);
	void Execute_Data(char *buffer);
	void Execute_Clear();

	CORBA::ORB_var *my_orb;

public:
	void Run(long cycles);

	KSynthesizer_impl(CORBA::ORB_var *my_orb);	// sure not nice, but don't know
											// a better way...
	~KSynthesizer_impl();

// exported CORBA functions

    CORBA::Long getModuleCount();
    CORBA::Boolean getModuleInfo( CORBA::Long nr, ModuleInfo*& info );

	void Execute(const char *line);
	CORBA::Boolean SyntaxCheck(char *&error);

    void Start( CORBA::Long cycles );
	void Stop( );
};

#endif
