	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _MODULESERVER_H_
#define _MODULESERVER_H_

#include <stdio.h>
#include <string.h>

#ifdef HAVE_MINI_STL
#include <ministl/list>
#else
#include <list>
#endif

//#define MODULESERVER_DEBUG

class Module
{
public:
	static void *Creator();
};

template<class T>
class ModuleServer
{
	class ModuleDesc
	{
	public:
		char *name;
		void *(*creator)();
		//void *creator;
	};

public:
	list<ModuleDesc *> ModuleList;

	long getModuleCount()
	{
		return(ModuleList.size());
	}

	char *getModuleName(int nr)
	{
		list<ModuleDesc *>::iterator i;

		i = ModuleList.begin();
		while(nr != 0) { nr--; i++; }
		if(i != ModuleList.end()) return((*i)->name);
		return(NULL);
	}

	void *getModule(char *name)
	{
		list<ModuleDesc *>::iterator i;
		for (i=ModuleList.begin();i != ModuleList.end();i++)
		{
			if(strcmp(name,(*i)->name) == 0)
			{
				return((*i)->creator());
			}
		}
		return(NULL);
	}

	void RegisterModule(char *name,void *(creator)())
	{
		ModuleDesc *MD = new ModuleDesc;
#ifdef MODULESERVER_DEBUG
		printf("[ModuleServer] module %s registered\n",name);
#endif
		MD->name = strdup(name);
		MD->creator = creator;
		ModuleList.push_back(MD);
#ifdef MODULESERVER_DEBUG
		printf("[ModuleServer] registration complete.\n");
#endif
	}
};

class ModuleClient
{
public:
	ModuleClient(void *(msget)(), char *name, void *(creator)())
	{
		ModuleServer<Module> *ms = (ModuleServer<Module> *)msget();
		ms->RegisterModule(name,creator);
	}
};

#endif
