	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "synth.h"
#include <stdio.h>
#include <sys/time.h>

void do_time(KSynthesizer *Synthesizer, char *x, int fragment)
{
	timeval start,stop;
	long i,bytes;

	
	gettimeofday(&start,NULL);
	bytes = 0;
	for(i=0;i<800;i++)
	{
		bytes += fragment*5;
		Synthesizer->Run(fragment);
	}
	
	gettimeofday(&stop,NULL);

	long diff;
	diff = (stop.tv_sec-start.tv_sec)*1000+(stop.tv_usec-start.tv_usec)/1000;
	int kbps = (bytes*1000/diff)/1024;
	printf("%20s [%4d]   %9ld KB/sec  %5.2f%% cpu\n",x,fragment,kbps,4400.0/(float (kbps)));
}

int main( int argc, char **argv )
{
// ---- connect to synthesizer

	CORBA::ORB_var orb = CORBA::ORB_init( argc, argv, "mico-local-orb" );
	CORBA::BOA_var boa = orb->BOA_init( argc, argv, "mico-local-boa" );

	CORBA::Object_var obj =
		orb->bind ("IDL:KSynthesizer:1.0", "inet:localhost:8888");
	if (CORBA::is_nil (obj)) {
		fprintf(stderr,"no synthesizer object found, start synth_server\n");
		exit(1);
	}

	KSynthesizer_var Synthesizer = KSynthesizer::_narrow (obj);

// ---- now Synthesizer is a valid KSynthesizer ;)

	
	char buffer[1024];


	int i,p;
	for(i=0;i<(Synthesizer->getModuleCount());i++)
	{
		Synthesizer->Execute("clear");
		ModuleInfo *minfo;
		if(Synthesizer->getModuleInfo(i,minfo) && strcmp(minfo->name,"Synth_PLAY") != 0)
		{
			int nr;
			for(nr = 0;nr < 5; nr++)
			{
				sprintf(buffer,"create mod%d = %s(",nr,(char *)minfo->name);
				for(p=0;p<minfo->inports.length();p++)
				{
					if(p!=0) strcat(buffer,",");
					strcat(buffer,"0");
				}
				strcat(buffer,");");
				Synthesizer->Execute(buffer);
			}

			char *errors;
			Synthesizer->SyntaxCheck(errors);

			do_time(Synthesizer,minfo->name,256);
			do_time(Synthesizer,minfo->name,512);
		}
	}

	return 0;
}
