	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include <stdio.h>
#include <math.h>

main(int argc,char **argv)
{
	float frequency;
	int len,i;
	int outval;
	char ov[2];

	if(argc != 2)
	{
		fprintf(stderr,"usage: %s <len in seconds>\n",argv[0]);
		exit(1);
	}
	len = atoi(argv[1]) * 44100;
	for(i=0;i<len;i++)
	{
		/*frequency = (100*i)/len*40; linear */
		frequency = pow(2,(float)((float)(65*i)/len)/12)*44; /* exponential */
		outval = sin((float)i/(44100/frequency)*2*M_PI)*32700;
		ov[0] = outval % 256;
		ov[1] = outval / 256;
		fwrite(ov,1,2,stdout);
	}
}
