/***************************************************************************
                          timebar.cpp  -  description
                             -------------------
    begin                : Fri Dec 17 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "timebar.h"

#include <qpainter.h>
#include <qrect.h>
#include <qcolor.h>
#include <qfont.h>

#include <stdlib.h>
#include <stdio.h>

#ifndef MAX
#define MAX(a,b)	(a < b ? b : a)
#endif

Timebar::Timebar(QWidget *parent, const char *name ) : QFrame(parent,name)
{
	QFont	f;
	int		s;
	
	setFrameStyle(QFrame::Panel|QFrame::Raised);
	setLineWidth(1);
	m_starttime = 0;
	m_endtime = 60000000;
	m_startselect = 0;
	m_endselect = -1;
	m_mode = Timebar::FixLeft;
	m_format = "%h:%2m:%2s.%3u";
	
	m_qp = new QPainter(this);
	f = m_qp->font();
	s = MAX(10,f.pointSize() / 2);
	//printf("%i\n",s);
	f.setPointSize(s);
	m_qp->setFont(f);
}

Timebar::~Timebar()
{
	delete m_qp;
}

void	Timebar::draw()
{
	int				x,y,w,h;
	long long	delta;
	long long	microsecpp,v;
	long long	msize,mstart,moffset;
	long long	dsize,dstart,doffset;
	int				i,n,o;
	QString		str;

 	erase(1,1,width() - 2,height() - 2);
	setFrameStyle( QFrame::Panel | QFrame::Raised );
	setLineWidth( 1 );
  QFrame::drawFrame(m_qp);

//	sprinttf(str,m_format,m_starttime);
//	printf("B: STime = %Li; Str = %s\n",m_starttime,str.data());
//	sprinttf(str,m_format,m_endtime);
//	printf("B: ETime = %Li; Str = %s\n",m_endtime,str.data());
	
	delta = m_endtime - m_starttime;
	microsecpp = delta / width();
//	sprinttf(str,m_format,microsecpp);
//	printf("B: MSPP = %Li; Str = %s\n",microsecpp,str.data());
	
	msize = microsecpp * 10;
//	sprinttf(str,m_format,msize);
//	printf("B: MSize = %Li; Str = %s\n",msize,str.data());
	msize = roundup(microsecpp * 10);
//	sprinttf(str,m_format,msize);
//	printf("B: MSize = %Li; Str = %s\n",msize,str.data());
	
	mstart = (m_starttime / msize + 1) * msize;
	moffset = (msize - (m_starttime % msize)) % msize;
	dsize = roundup(msize * 10);
	dstart = (m_starttime / dsize + 1) * dsize;
	doffset = (dsize - (m_starttime % dsize)) % dsize;
	
	o = doffset / msize;
	n = delta / msize;
	
	for(i = -10;i < n;i++)
	{
		v = m_starttime + moffset + i * msize;
		if(m_stopmark > m_starttime && v > m_stopmark)
		{
			x = 1 + ((m_stopmark - m_starttime) * width()) / delta;
			y = height() - 12;
			w = 0;
			h = 10;
			m_qp->drawLine(x,y,x + w,y + h);
		
			v = m_stopmark;
			sprinttf(str,m_format,v);
//			printf("D: Time = %Li; Str = %s\n",v,str.data());
			x = 1 + ((m_stopmark - m_starttime) * width()) / delta;
			y = MAX(0,height() - 20);
			w = 100;
			h = 12;
			m_qp->drawText(x + 2,y,w,h,AlignTop|AlignLeft,str.data());
			break;
		}
		x = 1 + ((moffset + i * msize) * width()) / delta;
		y = height() - 6;
		w = 0;
		h = 4;
		m_qp->drawLine(x,y,x + w,y + h);
//		sprinttf(str,m_format,v);
//		printf("M: Time = %Li; Str = %s\n",v,str.data());
		
		if((i - o + 10) % 10 == 5)
		{
			x = 1 + ((moffset + i * msize) * width()) / delta;
			y = height() - 9;
			w = 0;
			h = 7;
			m_qp->drawLine(x,y,x + w,y + h);
		
		}
		if((i - o + 10) % 10 == 0)
		{
			long long	v2;
			int				w2;
			
			x = 1 + ((moffset + i * msize) * width()) / delta;
			y = height() - 12;
			w = 0;
			h = 10;
			m_qp->drawLine(x,y,x + w,y + h);
		
			v = m_starttime + moffset + i * msize;
			sprinttf(str,m_format,v);
//			printf("D: Time = %Li; Str = %s\n",v,str.data());
			x = 1 + ((moffset + i * msize) * width()) / delta;
			y = MAX(0,height() - 20);
			w = 100;
			h = 12;
			
			v2 = m_starttime + moffset + i * msize;
			w2 = m_qp->boundingRect(x + 2,y,w,h,AlignTop|AlignLeft,str.data()).width();
			
			if(!(m_stopmark > m_starttime && (m_stopmark - v2) * width() / delta < w2 + 10))
			{
				m_qp->drawText(x + 2,y,w,h,AlignTop|AlignLeft,str.data());
			}
		}
	}
}

long long	Timebar::roundup(long long t)
{
//	if(t > 86400000000)
//		t = (t / 86400000000) * 86400000000;
	
	if(t > 600000000)
		t = 3600000000UL; // 1 Hour
	else if(t > 60000000)
		t = 600000000; // 10 Minutes
	else if(t > 10000000)
		t = 60000000; // 1 Minute
	else if(t > 1000000)
		t = 10000000; // 10 Seconds
	else if(t > 100000)
		t = 1000000; // 1 Second
	else if(t > 10000)
		t = 100000; // 100 Milli Seconds
	else if(t > 1000)
		t = 10000; // 10 Milli Seconds
	else if(t > 100)
		t = 1000; // 1 Milli Second
	else if(t > 10)
		t = 100; // 100 Micro Seconds
	else
		t = 10; // 10 Micro Seconds
		
	return t;
}


void	Timebar::resizeEvent(QResizeEvent *re)
{
	long long	wn,wo;
	long long	delta,center;
	
	switch(m_mode)
	{
		case Timebar::FixLeft:
			wn = re->size().width();
			wo = re->oldSize().width();
		
			delta = m_endtime - m_starttime;
		
			setRangeMicroSeconds(m_starttime,m_starttime + wn * delta / wo);
		break;
		case Timebar::FixRight:
			wn = re->size().width();
			wo = re->oldSize().width();
		
			delta = m_endtime - m_starttime;
		
			setRangeMicroSeconds(m_endtime - wn * delta / wo,m_endtime);
		break;
		case Timebar::FixCenter:
			wn = re->size().width();
			wo = re->oldSize().width();
		
			delta = m_endtime - m_starttime;
			center = (m_endtime + m_starttime) / 2;
		
			setRangeMicroSeconds(center - wn * delta / wo / 2,center + wn * delta / wo / 2);
		break;
		case Timebar::Scale:
		break;
		default:
			fprintf(stderr,"Timebar: wrong mode! Set to Timebar::FixLeft.\n");
			setMode(Timebar::FixLeft);
			wn = re->size().width();
			wo = re->oldSize().width();
		
			delta = m_endtime - m_starttime;
		
			setRangeMicroSeconds(m_starttime,m_starttime + wn * delta / wo);
	}
}

void	Timebar::paintEvent(QPaintEvent *pe)
{
	draw();
}

void	Timebar::sprinttf(QString &d,QString f,long long v)
{
	long long	h,m,s,u;
	int				t,l;
	QString	 	fi,str;

	v /= 1000;
	u = v % 1000;
	s = (v / 1000) % 60;
	m = (v / 60000) % 60;
	h = (v / 3600000);

	d = "";

	for(t = 0;t < (int)f.length();t++)
	{
		if(f[t] != '%')
		{
			d += f[t];
		}
		else
		{
			str = f.mid(t + 1,64);
			if((l = atoi(str.data())) != 0)
			{
				fi.sprintf("%%0%ii",l);
				t++;
			}
			else
			{
				fi.sprintf("%%i");
			}
			switch(f[++t])
			{
				case 'i':
					str.sprintf(fi,v);
				break;
				case 'u':
					str.sprintf(fi,u);
				break;
				case 's':
					str.sprintf(fi,s);
				break;
				case 'm':
					str.sprintf(fi,m);
				break;
				case 'h':
					str.sprintf(fi,h);
				break;
				default:
					str = f[t];
			}
			d += str;
		}
	}
}

/**  */
void Timebar::setRangeMicroSeconds(long long st,long long et)
{
	printf("setRangeMicroSeconds(%Li,%Li);\n",st,et);
	if(st < et)
	{
		m_starttime = st;
		m_endtime = et;
		draw();
	}
}

/**  */
void Timebar::setRangeMilliSeconds(long long st,long long et)
{
	printf("setRangeMilliSeconds(%Li,%Li);\n",st,et);
	if(st < et)
	{
		m_starttime = st * 1000;
		m_endtime = et * 1000;
		draw();
	}
}

/**  */
void Timebar::setRangeSeconds(int st,int et)
{
	printf("setRangeSeconds(%i,%i);\n",st,et);
	if(st < et)
	{
		m_starttime = (long long)st * 1000000;
		m_endtime = (long long)et * 1000000;
		draw();
	}
}

/**  */
void Timebar::setStartMicroSecond(long long st)
{
	long long	delta;
	
	delta = st - m_starttime;
	printf("setStartMicroSecond(%Li);",st);
	
	m_starttime += delta;
	m_endtime += delta;
	
	printf("    (%Li,%Li);\n",m_starttime,m_endtime);
	
	draw();
}

/**  */
void Timebar::setStartMilliSecond(long long st)
{
	long long	delta;
	
	delta = st * 1000 - m_starttime;
	printf("setStartMilliSecond(%Li);",st);
	
	m_starttime += delta;
	m_endtime += delta;
	
	printf("    (%Li,%Li);\n",m_starttime,m_endtime);
	
	draw();
}

/**  */
void Timebar::setStartMilliSecond(int st)
{
	setStartMilliSecond((long long)st);
}

/**  */
void Timebar::setStartSecond(int st)
{
	setStartMilliSecond((long long)st * 1000);
}

/**  */
int Timebar::startSecond()
{
	return m_starttime / 1000000;
}

/**  */
int Timebar::endSecond()
{
	return m_endtime / 1000000;
}

/**  */
void Timebar::setMicroSecondsPerPixel(long long mspp,Timebar::Mode mode)
{
	long long center;
	
	if(m_mode != Timebar::Scale)
	{
		mode = m_mode;
	}
	switch(mode)
	{
		case Timebar::FixLeft:
			setRangeMicroSeconds(m_starttime,m_starttime + mspp * width());
		break;
		case Timebar::FixRight:
			setRangeMicroSeconds(m_endtime - mspp * width(),m_endtime);
		break;
		case Timebar::FixCenter:
			center = (m_endtime + m_starttime) / 2;
			setRangeMicroSeconds(center - mspp * width() / 2,center + mspp * width() / 2);
		break;
		default:
			fprintf(stderr,"Timebar: wrong mode! Use Timebar::FixLeft.\n");
			setRangeMicroSeconds(m_starttime,m_starttime + mspp * width());
	}
	draw();
}

/**  */
long long Timebar::microSecondsPerPixel()
{
	long long	delta;
	
	delta = m_endtime - m_starttime;
	
	return delta / (long long)width();
}

/**  */
void Timebar::setStopMarkMicroSeconds(long long sm)
{
	m_stopmark = sm;
	draw();
}

/**  */
void Timebar::setStopMarkMilliSeconds(long long sm)
{
	setStopMarkMicroSeconds(sm * 1000);
}

/**  */
void Timebar::setStopMarkMilliSeconds(int sm)
{
	setStopMarkMilliSeconds((long long)sm);
}

/**  */
void Timebar::setStopMarkSeconds(int sm)
{
	setStopMarkMilliSeconds((long long)sm * 1000);
}

/**  */
long long Timebar::stopMarkMicroSeconds()
{
	return m_stopmark;
}

/**  */
void Timebar::setMode(Timebar::Mode fixmode)
{
	switch(m_mode)
	{
		case Timebar::FixLeft:
		case Timebar::FixRight:
		case Timebar::FixCenter:
		case Timebar::Scale:
			m_mode = fixmode;
		break;
		default:
			fprintf(stderr,"Timebar::setMode() wrong mode! Set to Timebar::FixLeft.\n");
			m_mode = Timebar::FixLeft;
	}
	draw();
}

/**  */
Timebar::Mode Timebar::mode()
{
	return m_mode;
}









