/***************************************************************************
                          ksoundsysdoc.h  -  description
                             -------------------
    begin                : Sun Dec 26 01:22:14 CET 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSOUNDSYSDOC_H
#define KSOUNDSYSDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>

#include "csample.h"
#include "ksoundwidget.h"

// forward declaration of the KSoundSys classes
class KSoundSysView;

/**	KSoundSysDoc provides a document object for a document-view model.
  *
	* The KSoundSysDoc class provides a document object that can be used in conjunction with the classes KSoundSysApp and KSoundSysView
	* to create a document-view model for standard KDE applications based on KApplication and KTMainWindow. Thereby, the document object
	* is created by the KSoundSysApp instance and contains the document structure with the according methods for manipulation of the document
	* data by KSoundSysView objects. Also, KSoundSysDoc contains the methods for serialization of the document data from and to files.
	*
	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
	* @version KDevelop version 0.4 code generation
	*/
class KSoundSysDoc : public QObject
{
  Q_OBJECT

 public:
  /** Constructor for the fileclass of the application */
  KSoundSysDoc(QWidget* parent, const char *name=0);
  /** Destructor for the fileclass of the application */
  ~KSoundSysDoc();
	/** adds a view to the document which represents the document contents. Usually this is your main view. */
  void setView(KSoundSysView* m_pView);
	/** removes a view from the list of currently connected views */
	void removeView(KSoundSysView* m_pView);
  /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
  void setModified(bool modified=true){ b_modified=modified; }
	/** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
  bool isModified(){ return b_modified;}
	/** "save modified" - asks the user for saving if the document is modified */
	bool saveModified();	
	/** deletes the document's contents */
	void deleteContents();
	/** initializes the document generally */
	bool newDocument();
	/** initializes the document with formatdialog */
	bool newFormatedDocument();
	/** closes the acutal document */
	void closeDocument();
	/** loads the document by filename and format and emits the updateViews() signal */
  bool openDocument(const char* filename, const char* format=0);
  /** saves the document under filename and format.*/	
  bool saveDocument(const char* filename, const char* format=0);
	/** sets the path to the file connected with the document */
	void pathName(const char* path_name);
	/** returns the pathname of the current document file*/
	const QString& getPathName() const;
	/** sets the filename of the document */
	void title(const char* title);
	/** returns the title of the document */
	const QString& getTitle() const;
  /**  */
  CSample* sample();
  /**  */
  void insertSilence();
  /**  */
  void insertSinus();
  /**  */
  void insertSquare();
  /**  */
  void changeFormat();
  /**  */
  void blur();
	
 public slots:
 	/** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
 	  * As this view normally repaints itself, it is excluded from the paintEvent. */
 	void slotUpdateAllViews(KSoundSysView* pSender);
  /**  */
  void copy(CSample &cnps);
  /**  */
  void paste(CSample &sample);
  /**  */
  void cut(CSample &sample);
  /**  */
  void optimizeDCOffset();
  /**  */
  void optimizeVolume();
  /**  */
  void envelope();
  /**  */
  void distort();
  /**  */
  void deeppass();
  /**  */
  void highpass();
  /**  */
  void echo();
  /**  */
  void expand();
  /**  */
  void compress();
  /**  */
  void hullcurve();
  /**  */
  void noisegate();
  /**  */
  void fuzz();
  /**  */
  void changeDCOffset();
  /**  */
  void volume();
  /**  */
  void pitchshift();
  /**  */
  void takepitch();
  /**  */
  void record();
  /**  */
  void pause();
  /**  */
  void stop();
  /**  */
  void play();
 	
 private:
 	/** the modified flag of the current document */
 	bool						b_modified;
	QString					m_title;
	QString					m_path;
	CSample					m_sample;
 	/** the view currently connected to the document */
	KSoundSysView*	m_view;	

signals: // Signals
  /**  */
  void signalMode(KSoundWidget::Mode mode);
  /**  */
  void signalBusy(bool);

protected:
	void	timerEvent(QTimerEvent *te);
};

#endif // KSOUNDSYSDOC_H





