/***************************************************************************
                          kscalebar.cpp  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kscalebar.h"

KScaleBar::KScaleBar(QWidget *parent = NULL,uint m = 0) :
	QFrame(parent)
{
	setMode(m);

	mb_pressed = 0;
	min_value = 0;
	max_value = 100;
	nmarks = 10;

	qp = new QPainter(this);

	format = "%.1f";
}

KScaleBar::~KScaleBar()
{
	delete qp;
}

void	KScaleBar::draw()
{
	QColor		black;
	int		x,y,w,h;
	uint		t;
	double		v,vt = 0,vb,vs = 0,vbs;
	QString		str;

	black.setRgb(0,0,0);

	setFrameStyle( QFrame::Panel | QFrame::Raised );
	setLineWidth( 2 );

	vbs = 0;
	switch(mode & (ZERO_TOP | ZERO_MID | ZERO_BOTTOM))
	{
		case ZERO_TOP:
			vt = min_value;
			vb = max_value;
			vs = (max_value - min_value) / (nmarks - 1);
		break;
		case ZERO_MID:
			vt = min_value;
			vb = max_value;
			vs = -(double)max_value / (double)(nmarks - 1) * 2;
			vbs = (double)min_value / (double)(nmarks - 1) * 2;
		break;
		case ZERO_BOTTOM:
			vt = max_value;
			vb = min_value;
			vs = (min_value - max_value) / (nmarks - 1);
		break;
	}

	//qp->begin(this);
	qp->setPen(black);
	v = vt;
	for(t = 1;t < nmarks - 1;t++)
	{
		if(vbs != 0 && v == 0)
		{
			vs = vbs;
		}
		v += vs;
		//printf("%f %f %f %f %f\n",v,vs,vbs,vt,vb);
		str.sprintf(format,v);
		if((mode & (LEFT_SIDED | RIGHT_SIDED)) == LEFT_SIDED)
		{
			x = 4;
			y = (t * 2 + 1) / 2 * height() / (nmarks - 1);
			w = width() - 12;
			h = 30;
			qp->drawText(x,y - h / 2,w,h,
				AlignRight|AlignVCenter,
				str,strlen(str));
			x = width() - 8;
			y = (t * 2 + 1) / 2 * height() / (nmarks - 1);
			w = 4;
			h = 0;
			qp->drawLine(x,y,x + w,y + h);
		}
		else
		{
			x = 4;
			y = (t * 2 + 1) / 2 * height() / (nmarks - 1);
			w = 4;
			h = 0;
			qp->drawLine(x,y,x + w,y + h);
			x = 12;
			y = (t * 2 + 1) / 2 * height() / (nmarks - 1);
			w = width() - 12;
			h = 30;
			qp->drawText(x,y - h / 2,w,h,
				AlignLeft|AlignVCenter,
				str,strlen(str));
		}
	}
	//qp->end();
}

void	KScaleBar::paintEvent(QPaintEvent *pe)
{
	if(pe == NULL) return;
	draw();
}





