/***************************************************************************
                          kgraphedit.h  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __KGRAPHEDIT__
#define __KGRAPHEDIT__

#include <qwidget.h>
#include <qpainter.h>

#include <math.h>

#ifndef SQR
#define SQR(a)		((a) * (a))
#endif

#ifndef MIN
#define MIN(a,b)	((a) < (b)?(a):(b))
#endif
#ifndef MAX
#define MAX(a,b)	((a) > (b)?(a):(b))
#endif

class KGraphEdit : public QWidget
{
Q_OBJECT

protected:
	double			left,right;
	QArray<double>		points;

	QColor			bgcolor,linecolor,pointcolor,gridcolor;
	int			pointshape;
	QPainter		*painter;
	int			sel;

public:
	KGraphEdit(QWidget*parent=0,const char*name=0,double left=0.0,double right=1.0);
	~KGraphEdit();

	void		setLeftPoint(double);
	double		getLeftPoint();
	void		setRightPoint(double);
	double		getRightPoint();
	void		addPoint(double x,double y);
	void		getPoint(int,double*,double*);
	int		getNPoints();

	int		delPoint(double x,double y);

	int		movePoint(double x,double y,double xn,double yn);

	double		getValue(double);

	void		reset();

	void		setBackgroundColor(QColor);
	QColor		getBackgroundColor();
	void		setLineColor(QColor);
	QColor		getLineColor();
	void		setGridColor(QColor);
	QColor		getGridColor();
	void		setPointColor(QColor);
	QColor		getPointColor();

protected:
	void		paintEvent(QPaintEvent *);
	void		mousePressEvent(QMouseEvent *);
	void		mouseReleaseEvent(QMouseEvent *);
	void		mouseMoveEvent(QMouseEvent *);
	void		draw();
	void		draw(int,int,int,int);

	void		sort();
};


#endif

