/***************************************************************************
                          options.h  -  description
                             -------------------
    begin                : Sat Feb 5 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONS_H
#define OPTIONS_H

#include <kslider.h>

#include <qwidget.h>
#include <qtabdialog.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlcdnumber.h>
#include <qlabel.h>


class options : public QTabDialog  {

	 	
public:
	options(QWidget *parent=0, const char *name=0);
	~options();

	void initDialog();

public: // Public attributes
  /** record options */
  QWidget* rec;
  /** mp3 options */
  QWidget* mp3;
  QWidget* general;

  QLabel* label_vbr;
  QLabel* label_bitrate_freq1;
  QLabel* label_bitrate_freq2;
  QLabel* label_bitrate_freq3;
  QLabel* label_bitrate;

  QGroupBox* box_bitrate;

  QCheckBox* fast;
  QCheckBox* voice;
  QCheckBox* quality;
  QCheckBox* checksum;
  QCheckBox* copyright;
  QCheckBox* non_original;
  QCheckBox* graphical;

  KSlider* bitrate_slider;
  QCheckBox* vbr;
  KSlider* vbr_slider;
  QLCDNumber* lcd_bitrate;
  QLCDNumber* lcd_vbr;

  QButtonGroup* mp3_mode;
  QRadioButton* mp3_mono;
  QRadioButton* mp3_force;
  QRadioButton* mp3_joint;
  QRadioButton* mp3_stereo;

  /** record program */
  QButtonGroup* group_prog;
  QRadioButton* soundrecord;
  QRadioButton* sox;

  QButtonGroup* group_ask;
  QRadioButton* ask;
  QRadioButton* overwrite;
  QRadioButton* neu;

  QButtonGroup* group_bit;
  QRadioButton* bit_8;
  QRadioButton* bit_16;

  QButtonGroup* group_stereo;
  QRadioButton* stereo;
  QRadioButton* mono;

  QButtonGroup* group_samplerate;
  QRadioButton* rate_16;
  QRadioButton* rate_22;
  QRadioButton* rate_24;
  QRadioButton* rate_32;
  QRadioButton* rate_44;
  QRadioButton* rate_48;

  /** Layout */
  QHBoxLayout* box_rec;
  QVBoxLayout* box_ask;
  QVBoxLayout* box_record;
  QVBoxLayout* box_program;
  QVBoxLayout* box_sample;
  QVBoxLayout* box_stereo;
  QVBoxLayout* box_bit;
  QVBoxLayout* box_stereo_bit;

  QVBoxLayout* box_mode;
};

#endif