//
// /home/ms/sidplay/qtsidplay/xsidplay-1.1-beta3/qt/textfile.h,v
//

#ifndef __TEXTFILE_H
#define __TEXTFILE_H

#include <strstream.h>
#include <iostream.h>
//#include <iomanip.h>
#include <fstream.h>
#include <ctype.h>
#include <string.h>


class textFile
{

 public:  // --------------------------------------------------------- public
	
	const int maxLineLen = 128;

	textFile(const char* fileName);
	virtual ~textFile();
	
	virtual const unsigned long retLineNum();
	virtual int retLineLen();
	virtual const char* retLineBuf();
	virtual bool readNextLine();
	
	virtual bool endOfFile();
	
	// Return a buffer that contains the current line without spaces.
	virtual const char* retParseBuf();
	// Return a buffer that contains the current line without spaces
	// at current parse position.
	virtual const char* retCurParseBuf();
	
	// Check whether the first non-space character is a ``#'' or ``;''.
	virtual bool isComment();
	
	// Check whether the line does not contain any non-space characters.
	virtual bool isBlank();
	
	// Check whether the first characters are equal to a given keyword string.
	virtual bool isKeyword(const char *keyword);

	// After a keyword matched with the first characters, check whether the next
	// characters are equal to another given keyword string.
	virtual bool isAgainKeyword(const char *keyword);

	// Case-insensitive comparison of two strings up to ``sizeof(dest)''
	// characters.
	virtual int myStrNcaseCmp(char *source, const char *dest);
	
	virtual operator bool();


 protected:  // --------------------------------------------------- protected

	virtual bool zeroDelimiters();
	virtual bool loadFromDisk(char* buf, unsigned maxLen);
	virtual bool createParseCopy();
	

	ifstream* inFile;             // our input file stream
	unsigned long inFileLen;
	unsigned long leftToLoad;	// how much is left to be loaded from disk
	
	char lineBuf[maxLineLen+1];   // current line buffer
	char parseBuf[maxLineLen+1];  // line without white-space (see flag below)
	char *nextParseBuf;
	
	int inBuffer;		        // number of chars read into buffer
	int moreInBuffer;	        // <> 0, if more than one line buffered
	int lineLen;                  // actual number of chars till end of line
	char* nextLine;	        // pointer to start of next line, if available 
	
	unsigned long lineNum;        // line number in file
	
	bool haveParseCopy;           // true, if line contents were copied to an
	// extra buffer via a white-space eating
	// string stream
	bool status;
	bool isGood;                  // to prevent from using a bad inFile pointer
	

 private:  // ------------------------------------------------------- private

};


#endif
