//
// /home/ms/sidplay/qtsidplay/RCS/FilterDialog.cpp,v
//

#include "GlobalExt.h"
#include "FilterDialog.h"

#include <qpainter.h>
#include <qpixmap.h>
#include <math.h>

#include "images/filticon.xpm"
#define Inherited FilterDialogData

FilterDialog::FilterDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Filter Adjustment" );
	setFixedSize(width(),height());
	setIcon(*myMainIcon);

	presetButtons();
	paintFilterFunc();
}

FilterDialog::~FilterDialog()
{
}

void FilterDialog::presetButtons()
{
	isEnabled->setChecked(myEmuConfig.emulateFilter);
	setSliderValues();
}

void FilterDialog::updatePara1( int index )
{
	myEmuConfig.filterFs = 1.0+index*6.0;
	myEmuEngine.setConfig(myEmuConfig);
	paintFilterFunc();
}

void FilterDialog::updatePara2( int index )
{
	myEmuConfig.filterFm = 1.0+index;
	myEmuEngine.setConfig(myEmuConfig);
	paintFilterFunc();
}

void FilterDialog::updatePara3( int index )
{
	myEmuConfig.filterFt = index/100.0;
	myEmuEngine.setConfig(myEmuConfig);
	paintFilterFunc();
}

void FilterDialog::setDefaults()
{
	myEmuEngine.setDefaultFilterStrength();
	myEmuEngine.getConfig(myEmuConfig);
	setSliderValues();
	paintFilterFunc();
}

void FilterDialog::setFilterFlag( bool val )
{
	if (val != myEmuConfig.emulateFilter)
	{
		myEmuConfig.emulateFilter = val;
		myEmuEngine.setConfig(myEmuConfig);
		emit sendFilterFlag(val);
	}
}

void FilterDialog::receiveFilterFlag( bool val )
{
	isEnabled->setChecked(val);
	isEnabled->repaint(false);
}

void FilterDialog::setSliderValues()
{
	para1Sld->setValue((int)((myEmuConfig.filterFs/6.0-1.0)));
	para2Sld->setValue((int)(myEmuConfig.filterFm-1.0));
	para3Sld->setValue((int)(myEmuConfig.filterFt*100.0));
}

void FilterDialog::paintFilterFunc()
{
	QPixmap myFiltPic(filticon);
	QPainter paintBuf;
    paintBuf.begin(&myFiltPic);
	QColor myPenColor(0,0,255);  // rgb
	paintBuf.setPen(myPenColor);
	extern float filterTable[0x800];
	for (int i=0; i<0x800; i++)
	{
		paintBuf.drawPoint((int)(i/15.75),(int)(filterTable[i]*100.0));
	}
    paintBuf.end();
	
    QPainter paint(this);
	paint.drawPixmap(220,0,myFiltPic);
}

void FilterDialog::paintEvent( QPaintEvent * )
{
	paintFilterFunc();
}
