/*
  stores decoder in a form {ident,pointer}
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __DECODERARRAY_H
#define __DECODERARRAY_H


#include <iostream.h>



/**
  This is a mapping between an identifier (int) an an void Ptr.
  This can be used as an dynamic Array
*/

typedef struct {
  int id;
  void* ptr;
} ValueKeyPair;


class PtrArray {

  int fillPos;
  int nSize;

  ValueKeyPair** valueKeyPair;

 public:
  PtrArray(int nSize=5);
  ~PtrArray();

  int add(int id,void* aPtr);
  void* find(int id);
  void remove(int id);
  void remove(void* aPtr);
  int find(void* aPtr);

  int getFillgrade();
  int maxSize();
  void* getPtrAt(int i);  
  int getIdAt(int i);

};


#endif
