/*
  Interface to send messages from the gui to the thread
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <producer/core/threadNotifier.h>



ThreadNotifier::ThreadNotifier() {
  int i;
  
  freePos=0;
  readPos=0;
  fillgrade=0;

  for(i=0;i<_MAX_THREAD_ENTRIES;i++) {
    threadEntryArray[i]=new ThreadEntry();
    threadEntryArray[i]->valid=false;
  }
  pthread_mutex_init(&notifierMut,NULL);
}


ThreadNotifier::~ThreadNotifier() {
  int i;

  for(i=0;i<_MAX_THREAD_ENTRIES;i++) {
    delete threadEntryArray[i];
  } 
}


void ThreadNotifier::sendSyncMessage(int msg) {
}


void ThreadNotifier::sendAsyncMessage(int msg) {
  pthread_mutex_lock(&notifierMut);

  if (fillgrade == _MAX_THREAD_ENTRIES) {
    cout << "ThreadNotifier overflow! ignoring new state!"<<endl;
    cout << "queue dump:"<<endl;
    int i;
    for(i=0;i<_MAX_THREAD_ENTRIES;i++) {
      char msg='0'+threadEntryArray[i]->msg;
      cout << "Msg:"<<i<<"="<<msg<<endl;
    }
    cout << "dumpThreadInfo is:"<<endl;
    dumpThread();
    pthread_mutex_unlock(&notifierMut);
    return;
  }
  threadEntryArray[freePos]->msg=msg;
  threadEntryArray[freePos]->valid=true; 
  fillgrade++;
  freePos++;
  if (freePos == _MAX_THREAD_ENTRIES) {
    freePos=0;
  }
  pthread_mutex_unlock(&notifierMut);
}


int ThreadNotifier::hasAsyncMessage() {
  return (fillgrade > 0);
}


int ThreadNotifier::getAsyncMessage() {
  
  int back=-1;
  pthread_mutex_lock(&notifierMut);

  if (threadEntryArray[readPos]->valid == true) {
    back=threadEntryArray[readPos]->msg;

    readPos++;
    fillgrade--;
  }
  if (readPos == _MAX_THREAD_ENTRIES) {
    readPos=0;
  }
  pthread_mutex_unlock(&notifierMut);
  return back;
  
}



void ThreadNotifier::dumpThread() {
  cout << "no dumpThread avaiable"<<endl;
}
