/*
  a DataGenerator coordinates userinput and the running thread
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */






#ifndef __DATAGENERATOR_H
#define __DATAGENERATOR_H


#include <producer/core/deviceConfigGenerator.h>
#include <producer/core/deviceConfigController.h>
#include <deviceConfig/deviceConfig.h>
#include <producer/core/decoderID.h>


#define _THREAD_DELIVER_THEN_SLEEP    1
#define _THREAD_SLEEP                 2
#define _THREAD_DELIVER               3
#define _THREAD_NO_DELIVER            4


/**
  This class must be used for new data generation methods. 
  The DataGenerator implements
  the controller and the generator interface. The generator interface
  is only used by the thread. The controller interface is used
  by the user.
  <p>
  But there are dependencies between them (command "stop" by user
  must stop thread, etc..)
  This is because you must implement both interfaces in a typical
  DataGenerator.
  <p>
  The dataGenerator is the class from which you derive when you
  implement new data streams. Eg: write a LineIn/Microphone etc.
  For a Microphone reader the whole yaf-protocoll would be overkill.

*/


class DataGenerator : public DeviceConfigGenerator, 
                      public DeviceConfigController {
  
  DecoderID* id;

 public:
  DataGenerator();
  ~DataGenerator();
  
  // returns the new threadstate
  int updateDeviceConfig(DeviceConfig* newConfig);

  int open(char* filename );
  int close();
  int play();
  int pause();
  int jump(int);

  void kill();
  virtual void wakeUpThread(int lLockInProgress);
  
  /** 
      This is set during the creating process of a data generator.
      It gives this generator an id which makes it possible
      to identify the type of the generator.
      This type can be used to create a similiar decoder
      if the backend for this decoder crashes.
      This is a workaround for buggy decoders.
  */
  void setDecoderId(DecoderID* id);
  DecoderID* getDecoderId();
};

#endif
