/*
  mixes muliple configs to one
  Copyright (C) 1999  Rainer Maximini, Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <filter/mixerFilter.h>


MixerFilter::MixerFilter() {
  mixMemory=new signed int[_MAX_MIX_SIZE];
}


MixerFilter::~MixerFilter() {
  delete mixMemory;
}


void MixerFilter::transform(DeviceConfigArray* input,DeviceConfig* output) {
  AudioStream* outputAudioStream=output->getAudioStream();
  DeviceConfig* config;
  AudioBuffer* audioBuffer;

  MemChunk* memChunk;
  MemChunk* pcmChunk;

  int maxLen;
  int elements = input->getEntries();


  // Now we examine the output Config a bit, to avoid
  // stupid segfault if the internals of output
  // does not have a few basic requirements

  audioBuffer=outputAudioStream->getAudioBuffer();

  // This is the targetMemory
  pcmChunk=audioBuffer->getMemChunk();
  

  // now we copy all the unusefull informations
  // like musicname, id3tags, frequency, channels to the
  // output.
  // Its _really_ stupid to use eg. name of the first input
  // stream and the musicname,length etc.. as the name
  // for the outputstream, but until there is no better
  // specification fo this we do it this way
  config=input->getDeviceConfigAt(0);
  config->copyTo(output);

  // select the input with the biggest memory to mix
  // the user must take care that they are all the same frequency
  // (because this device cannot convert eg. 22,5KHz to eg. 44,1KHz)
  maxLen=input->getMaximumMemChunkLen();


  // Now we check if we have internally enough memory
  if (maxLen > _MAX_MIX_SIZE) {
    cout << "maximum mixer length too short! skipping bytes!"
         << "maxLen is:"<<maxLen<<" allowed is:"<<_MAX_MIX_SIZE<<endl;
    maxLen=_MAX_MIX_SIZE;
  }
  // does the outputbuffer have enought memory?
  if (maxLen > pcmChunk->getSize()) {
    maxLen=pcmChunk->getSize();
    cout << "maximum memChunk length too short! skipping bytes!"<<endl;
  }
  // are there too much input channels?
  if (elements > _MAX_MIX_ENTRIES) {
    cout << "too much mix streams. ignored!"<<endl;
    return;
  }
  // Ok, everything is in spec. start mixing..

  // We initialize the memory (we need==maxLen) with zeros
  memset(mixMemory,0,maxLen*sizeof(int));
  AudioStream* inputAudioStream;
  AudioInfo* audioInfo;

  for(int i=0;i<elements;i++) {
    inputAudioStream=input->getDeviceConfigAt(i)->getAudioStream();
    audioInfo=inputAudioStream->getAudioInfo();
    if (audioInfo->getSampleSize()==8) {
      cout << "8 Bit mixer not yet supported"<<endl;
      continue;
    }

    memChunk = inputAudioStream->getAudioBuffer()->getMemChunk();
    if (memChunk != NULL) {
      mixToBuffer(memChunk->getPtr(),memChunk->getLen(),mixMemory);
    }
  }  


  signed int* srcPtr=mixMemory;
  signed int* endPtr=mixMemory+maxLen/2;
  short* destPtr= (short*)pcmChunk->getPtr();

  // now we copy the mixBuffer back to the targetMemory
  while ( srcPtr != endPtr ) {
    if (*srcPtr < SHRT_MIN) *destPtr++ = SHRT_MIN; 
    else if (*srcPtr > SHRT_MAX) *destPtr++ = SHRT_MAX; 
    else *destPtr++ = *srcPtr;
    srcPtr++;
  }   
  
  // now update the output classes
  audioBuffer=outputAudioStream->getAudioBuffer();
  audioBuffer->setMemChunk(pcmChunk);
  pcmChunk->setLen(maxLen);
}
  


void MixerFilter::mixToBuffer(char *input,int len,int *mixMem){
  signed int *target=mixMem;


  short* input2=(short*)input;
  int len2=len/2;
  
  for(int i=0; i<len2; i++) {
    *target++ += *input2++;
  }
  
}
