/*
  a FFT filter with real/imagery part
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <fixFFTFilter.h>

#if (__GNUC__ < 2 || ( __GNUC__ == 2 && __GNUC_MINOR__ < 91 ) )
#warning "inline code disabled! (buggy egcs version)"
#undef __NO_MATH_INLINES
#define __NO_MATH_INLINES 1
#endif
#include <math.h>


FixFFTFilter::FixFFTFilter(int fftPoints,int analyserSize) {
  this->fftPoints=fftPoints;
  this->analyserSize=analyserSize;
  redata= new fixed[2*fftPoints];
  imdata= new fixed[2*fftPoints];
  fixFFT=new FixFFT();
  loud=   new fixed[2*fftPoints];
  
  
}

FixFFTFilter::~FixFFTFilter() {
  delete redata;
  delete imdata;
  delete fixFFT;
  delete loud;
}

int FixFFTFilter::fft16(DeviceConfig* config) {
  int i;

  AudioStream* audioStream=config->getAudioStream();
  AudioInfo* audioInfo=audioStream->getAudioInfo();

  AudioBuffer* audioBuffer=audioStream->getAudioBuffer();
  MemChunk* memChunk=audioBuffer->getMemChunk();
  
  if (memChunk == NULL) {
    return false;
  }

  short* ptr=(short*)memChunk->getPtr();
  int stereo=audioInfo->getStereo();
  int len=memChunk->getLen()/(stereo+1);

  if (len < fftPoints*2) {
    return false;
  }
  int spec_len=fftPoints*2;
  int spec_base=(int)(log(fftPoints*2)/log(2));

  int nch=stereo+1;
  int j=0;
  for(i=0;i<spec_len;i++) {
    if(nch==2) {
      redata[i]=(ptr[j]+ptr[j+1])>>1;
      imdata[i]=0;
      j+=2;
    }
    else {
      redata[i]=ptr[i];
      imdata[i]=0;
    }
  }			
  fixFFT->window(redata,spec_len);
  fixFFT->fix_fft(redata,imdata,spec_base,FALSE);
  fixFFT->fix_loud(loud,redata,imdata,spec_len/2,0);

  return true;
}

int FixFFTFilter::getPoints() {
  return fftPoints;
}

int FixFFTFilter::getAnalyserSize() {
  return analyserSize;
}

short* FixFFTFilter::getPointPtr() {
  return (short*)loud;
}


