/*
  generic outputdevice for yaf
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __OUTPUTDEVICE_H
#define __OUTPUTDEVICE_H

#include <devices/nodeDevice.h>
#include <filter/filter.h>

#include <signal/toolkit/eventQueue.h>

#define _OUTPUT_GENERAL_EVENT      1


/**
   This adds two things to the device:
   <p>
   <pre>
   *an EventQueue 
   *an Accelerator
   </pre>
   </p>
   With the EventQueue the thread sends message to the GUI
   with the standard GUI event mechanism. Connect your
   Listeners with the standard methods.
   A connect in qt on the StreamInfoDevice would look like
   this:
   <pre>
   streamInfoDevice=new StreamInfoDevice();
   streamInfoDevice->setEventMask(_STREAMINFO_MUSIC_CHANGE);

   EventQueue eq=streamInfoDevice->getEventQueue();
   connect(eg,SIGNAL(processEvent(char)),this,SLOT(myslot(char)));
   </pre>
   <p>
   This sends events from the device to your gui each time the MusicInfo
   changes in the stream.
   <p>
   Note: OutputDevice is abstract!
*/
  


class OutputDevice : public NodeDevice {

  EventQueue* eventQueue;
  char* name;

 public:
  OutputDevice(char* name);
  virtual ~OutputDevice();

  char* getNodeName();

  /**
     usefull for the algorithms in the device
  */
  Accelerator* getAccelerator();
  EventQueue* getEventQueue();

};

#endif
  
  



