/* 
  abstract algorithms often used by these multimedia things 
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __ACCELERATOR_H
#define __ACCELERATOR_H


/**
   
   

   This class contains a collection of algorithms which
   are:
   <pre>
   i) time intensive
   ii) are often used in streaming 
   </pre>
   The filter classes uses these algorithms.
   The algorithms are in a seperate class, because this makes
   it possible to simply add special cpu support like MMX/3DNow.
*/


class Accelerator {

 public:
  Accelerator();
  virtual ~Accelerator();

  virtual void byteAdd(int* dest,char* src,int len);  // dest is int-Array!
  virtual void byteDiv(char* ptr,int div,int len);
  virtual void byteDiv(int* ptr,int div,int len);     // int-Array !
  virtual void byteMul(char* ptr,int mul,int len);
  virtual void bytePercentMul(char* ptr,int percent,int len);
  virtual void arrayCopy(char* dest,int* src,int len);
  

};
#endif
