/*
  base class for all streams
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __STREAM_H
#define __STREAM_H


#include <iostream.h>
#include <deviceConfig/info/statusInfo.h>


#define __STREAM_UNKNOWN    0
#define __STREAM_AUDIO      1
#define __STREAM_VIDEO      2
#define __STREAM_CONTROL    3
#define __STREAM_CONTAINER  4


/**
   This class is a base for all audio/video/control streams.
   It offers an id, which then can be used to safly cast an
   abstract stream to the valid type.
   <p><b>what belongs to a stream </b>
   <p>
   First the id, then the producer of the stream. A base stream 
   does not have time in it, or a name. All these "attributes"
   must be handled in derived classes.
   <p><b>recursive definitions?</b>
   It is _really_ useful to extend this class that it can contain
   other streams?
*/
   


class Stream {

  int id;
  void* producer;
  StatusInfo* statusInfo;


 public:
  Stream();
  virtual ~Stream();

  void setId(int id);
  int getId();
  
  // streamProducer are stored as a void pointer because
  // of a recursive inclusion!
  // you should safley cast it where you need it.
  void* getStreamProducer();
  void setStreamProducer(void* streamProducer);


  // every stream knows its state (playing,paused,stopped)
  void setStatusInfo(StatusInfo* statusInfo);
  StatusInfo* getStatusInfo();


  virtual void forward();
  virtual void print();
  virtual void copyTo(Stream* dest);
  virtual int isValid()=0;
  virtual void addLock()=0;
  virtual void removeLock()=0;

};
#endif
