/*
  stores the status of the stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __STATUSINFO_H
#define __STATUSINFO_H

#include <deviceConfig/info/info.h>
#include <iostream.h>

#define _STATUS_PLAYING          1
#define _STATUS_PAUSED           2
#define _STATUS_STOPPED          3

/**
   StatusInfo stores the status of the stream.
   A Stream knows the states. PLAYING, PAUSED and stopped.
   <p>
   The Producer must take care that the _change_ in the
   status always is delivered with zero Buffer info!
   <p>
   A change in the status must 
   <p>
*/


class StatusInfo : public Info {

 public:
  StatusInfo();
  ~StatusInfo();

  int getStatus();
  void setStatus(int status);

  int getEOF();
  void setEOF(int eof);

  void copyTo(StatusInfo* dest);

  void print();
 private:

  int status;
  int lEof;
};


#endif


  

