/*
  stores author/name/length etc. of song
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <deviceConfig/info/musicInfo.h>



MusicInfo::MusicInfo() {
  name=new Buffer(50);
  filename=new Buffer(50);
  len=0;
  jumps=0;
}


MusicInfo::~MusicInfo() {
  delete name;
  delete filename;
}



void MusicInfo::setName(char* newName) {
  name->clear();
  name->append(newName);
  setChange(true);
}


char* MusicInfo::getName() {
  return name->getData();
}



void MusicInfo::copyTo(MusicInfo* dest) {
  if (dest == NULL) {
    return;
  }

  dest->setName(getName());
  dest->setLen(getLen());
  dest->setFileName(getFileName());
  dest->setJumps(getJumps());
  
}


void MusicInfo::setLen(int sec) {
  len=sec;
  setChange(true);
}


int MusicInfo::getLen() {
  return len;
}


void MusicInfo::setFileName(char* aFilename) {
  if (filename == NULL) {
    return;
  }
  filename->clear();
  filename->append(aFilename);
  setChange(true);
}


char* MusicInfo::getFileName() {
  return filename->getData();
}


void MusicInfo::setJumps(int jumps) {
  this->jumps=jumps;
  setChange(true);
}


int MusicInfo::getJumps() {
  return jumps;
}




void MusicInfo::print() {
  cout << "MusicInfo-begin-"<<endl;
  cout << " name: "<<getName() 
       <<" len: "<< len
       <<" jumps: "<<jumps<<endl;
  cout << " file:"<<getFileName()<<endl;
  cout << "MusicInfo-end-"<<endl;
 
}


 
