/*
  describes a picture
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __PICTURE_H
#define __PICTURE_H



#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <sys/time.h>
#include <unistd.h>
#include "../inputPlugin/timeStamp.h"

#define PICTURE_NO_TYPE     -1

class Picture {

  unsigned char *luminance;              /* Luminance plane.   */
  unsigned char *Cr;                     /* Cr plane.          */
  unsigned char *Cb;                     /* Cb plane.          */
  unsigned char *data;                   /* Display plane.     */
  int locked;                            /* Lock flag.         */

  struct timeval displayTime;
  int width;
  int height;
  int bpp;

  int lThread;

  float picPerSec;
  int lumLength;
  int colorLength;
  TimeStamp* startTimeStamp;
  TimeStamp* endTimeStamp;
  int frameType;
  float vbvDelay;

 public:
  Picture(int width,int height,int bpp);
  ~Picture();

  int getLock();
  void setLock(int lock);


  inline unsigned char* getLuminancePtr() {return luminance;}
  inline unsigned char* getCrPtr() {return Cr;}
  inline unsigned char* getCbPtr() {return Cb;}

  int getHeight();
  int getWidth();
  int getBpp();

  int getLumLength();
  int getColorLength();
  

  void setThreadedDither(int lThread);
  int getThreadedDither();

  void setPicturePerSecond(float val);
  float getPicturePerSecond();

  float getVBVDelay();
  void setVBVDelay(float vbv);

  void setStartTimeStamp(TimeStamp* timeStamp);
  TimeStamp* getStartTimeStamp();

  void setEndTimeStamp(TimeStamp* timeStamp);
  TimeStamp* getEndTimeStamp();

  void setFrameType(int type);
  int getFrameType();

  void print(char* title);
};
#endif
