/*
  describes a picture
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "picture.h"



Picture::Picture(int width,int height,int bpp) {
  this->width=width;
  this->height=height;
  this->bpp=bpp;
  frameType=PICTURE_NO_TYPE;

  locked=false;
  lThread=false;
  lumLength=width * height;
  colorLength=width * height / 4;
  luminance = new unsigned char[lumLength];
  Cr = new unsigned char [colorLength];
  Cb = new unsigned char [colorLength];

  if ( (luminance == NULL) ||
       (Cr == NULL) ||
       (Cb == NULL) ) {
    cout << "allocation luminance/Cr/Cb error"<<endl;
    exit(0);
  }
  memset(luminance,0,lumLength);
  memset(Cr,0,colorLength);
  memset(Cb,0,colorLength);
  startTimeStamp=new TimeStamp();
  endTimeStamp=new TimeStamp();
  vbvDelay=0;
}


Picture::~Picture() {
  delete luminance;
  delete Cr;
  delete Cb;
  delete startTimeStamp;
  delete endTimeStamp;
}


int Picture::getLock() {
  return locked;
}


void Picture::setLock(int lock) {
  locked=lock;
}




int Picture::getHeight() {
  return height;
}


int Picture::getWidth() {
  return width;
}


int Picture::getBpp() {
  return bpp;
}


int Picture::getLumLength() {
  return lumLength;
}


int Picture::getColorLength() {
  return colorLength;
}
  



void Picture::setThreadedDither(int lThread) {
  this->lThread=lThread;
}


int Picture::getThreadedDither() {
  return lThread;
}
 

float Picture::getVBVDelay() {
  return vbvDelay;
}


void Picture::setVBVDelay(float vbv) {
  this->vbvDelay=vbv;
}


void Picture::print(char* title) {
  cout << title << " [START]"<<endl;
  printf("width:%d\n",width);
  printf("height:%d\n",height);
  printf("luminance%8x\n",luminance);
  printf("Cr:%8x\n",Cr);
  printf("Cb:%8x\n",Cb);
  cout << title << " [END]"<<endl;
  
  
}


void Picture::setPicturePerSecond(float val) {
  picPerSec=val;
}


float Picture::getPicturePerSecond() {
  return picPerSec;
}


void Picture::setStartTimeStamp(TimeStamp* aStamp) {
  aStamp->copyTo(startTimeStamp);
}


TimeStamp* Picture::getStartTimeStamp() {
  return startTimeStamp;
}

void Picture::setEndTimeStamp(TimeStamp* aStamp) {
  aStamp->copyTo(endTimeStamp);
}


TimeStamp* Picture::getEndTimeStamp() {
  return endTimeStamp;
}



void Picture::setFrameType(int type) {
  this->frameType=type;
}


int Picture::getFrameType() {
  return frameType;
}

