/*
  concret OutputClass
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __DSPX11OUTPUTSTREAM_H
#define __DSPX11OUTPUTSTREAM_H

#include "outputStream.h"
#include "../../yaf/shared/audio/audioWrapper.h"
#include "x11Window.h"
#include <pthread.h>
#include "avSyncer.h"


class DspX11OutputStream : public OutputStream {

  AudioWrapper* audioWrapper;
  X11Window* x11Window;
  AVSyncer* avSyncer;

  TimeStamp* videoTimeStamp;
  TimeStamp* diffTime;
  TimeStamp* waitTime;

  int lVideoInit;
  int lavSync;
  int lneedInit;
  AudioTime* audioTime;


 public:
  DspX11OutputStream(int bufferSize);
  ~DspX11OutputStream();

  // Audio Output

  int audioSetup(int frequency,int stereo,int sign,int big,int sixteen);
  void audioClose(void);
  int audioPlay(TimeStamp* startStamp,
		TimeStamp* endStamp,char *buffer, int size);
  void audioFlush();

  int getPreferredDeliverSize();


  // Video Output

  int openWindow(int width, int height,char *title);
  void closeWindow();
  void flushWindow();

  void putImage(TimeStamp* startStamp,
		TimeStamp* endStamp,struct Picture* pic);
  int getFrameusec();

  int getDepth();
  int getOutputInit();
  void setOutputInit(int lInit);

  void config(char* key, char* value);

  // methods which do not belong to the outputStream intferface;
  AVSyncer* getAVSyncer();

  
};



#endif
